package clinical.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import clinical.server.vo.Experiment;
import clinical.server.vo.Transformation;
import clinical.web.IProvenanceService;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.exception.BaseException;
import clinical.web.services.AnalysisInstanceDataResult;
import clinical.web.vo.AnalysisCompInfo;
import clinical.web.vo.AnalysisInfo;
import clinical.web.vo.DerivedDataInfo;
import clinical.web.vo.ExecutedTransformInfo;
import clinical.web.vo.MachineInfo;
import clinical.web.vo.TransformationInfo;

import junit.framework.TestSuite;

public class ProvenanceTests extends MyDBTestCase {

	public ProvenanceTests(String testName) throws IOException {
		super(testName, "test.properties", true);
	}

	public void testAddAnalysis() throws Exception {
		final boolean CREATE_TRANSFORMS = false;
		AnalysisInfo ai = new AnalysisInfo("preproc_test", "0001_0001");
		List<TransformationInfo> tiList = new ArrayList<TransformationInfo>(10);
		TransformationInfo ti = new TransformationInfo("PACKAGE",
				"PACKAGEVERSION", "fips-sm2-fsl",
				"v 1.6 2007/01/27 00:11:04 (PPC: v 1.2 2006/11/09 22:25:37");

		TransformationInfo ti2 = new TransformationInfo("PACKAGE",
				"PACKAGEVERSION", "ip_32R",
				"FSL Release 3.3 (64-bit) 2006/04/07");
		TransformationInfo ti3 = new TransformationInfo("PACKAGE",
				"PACKAGEVERSION", "bet", "FSL Release 3.3 (64-bit) 2006/04/07");
		tiList.add(ti);
		tiList.add(ti2);
		tiList.add(ti3);

		IProvenanceService ps = ServiceFactory.getProvenanceService(getDbID());

		if (CREATE_TRANSFORMS) {
			List<Transformation> tList = ps.addTransformations(getUi(), tiList);

			for (Transformation t : tList) {
				System.out.println(t);
			}
		} else {

			AnalysisCompInfo aci = createACI(1, 1, ai, ti, null);
			AnalysisCompInfo aci2 = createACI(2, 2, ai, ti2, aci);
			AnalysisCompInfo aci3 = createACI(3, 2, ai, ti3, aci);

			ai.addComponent(aci);
			ai.addComponent(aci2);
			ai.addComponent(aci3);

			List<AnalysisCompInfo> flowList = new ArrayList<AnalysisCompInfo>(3);
			flowList.add(aci2);
			flowList.add(aci3);
			
			ps.addAnalysisRecWithComponents(getUi(), ai, flowList);
		}
	}

	public void testDeleteAnalysis() throws Exception {
		// deletes an empty analysis from the database
		AnalysisInfo ai = new AnalysisInfo("preproc_test", "0001_0001");
		IProvenanceService ps = ServiceFactory.getProvenanceService(getDbID());

		ps.deleteAnalysis(getUi(), ai);
	}
	
	public void testDeleteMatchingExecutedTransforms() throws Exception {
		IProvenanceService ps = ServiceFactory.getProvenanceService(getDbID());
		Experiment exp = findExperiment("fBIRNPhaseII__0010");
		
        int expID = exp.getUniqueid().intValue();
        int visitID = 2;
		ps.deleteMatchingExecutedTransforms(getUi(), "000602155404", expID, visitID, null);
	}
	
	
	protected Experiment findExperiment(String expName) throws BaseException {
		IDBCache dbCache = ServiceFactory.getDBCache(getDbID());
		List<Experiment> expList = dbCache.getExperiments(getUi(), false);

		for (Experiment exp : expList) {
			if (exp.getName().equals(expName)) {
				return exp;
			}
		}
		return null;
	}

	// 26602
	public void testAddETIs() throws Exception {
		IProvenanceService ps = ServiceFactory.getProvenanceService(getDbID());
		Experiment exp = findExperiment("fBIRNPhaseII__0010");
		assertNotNull(exp);
		MachineInfo mi = new MachineInfo();
		mi.setArchitecture("x86_64");
		mi.setOpSystem("GNU/Linux");
		mi.setOsVersion("2.6.9-42.0.3.ELsmp");
		mi.setAddress("intuition");
		AnalysisInfo ai = new AnalysisInfo("preproc_test", "0001_0001");
		TransformationInfo ti = new TransformationInfo("PACKAGE",
				"PACKAGEVERSION", "fips-sm2-fsl",
				"v 1.6 2007/01/27 00:11:04 (PPC: v 1.2 2006/11/09 22:25:37");
		AnalysisCompInfo aci = createACI(1, 1, ai, ti, null);

		ExecutedTransformInfo eti = new ExecutedTransformInfo();
		eti.setTimestamp(new Date());
		eti.setTransform(ti);
		eti.setMachine(mi);
		eti.setAnalysis(ai);
		eti.setComponent(aci);
		eti.setNodeLevel(aci.getNodeLevel());
		eti
				.setArgUsed("/data/fBIRN/src/human/fips/ppc-global/fBIRNPhaseII/M_mc-fsl.ppc 000602155404/scanVisit__0006__0002/MRI__0001/AudOdd1/Native/Original__0001/NIFTI");

		DerivedDataInfo inDDI = new DerivedDataInfo();
		inDDI
				.setDataURI("/home/bozyurt.ucsd-fmri/tmp/000602155404/scanVisit__0006__0002/MRI__0001/AudOdd1/Analysis/Original__0001/FIPS_MBTS_preprocs__0008__0001/M_mc-fsl.preproc");
		inDDI.setSubjectID("000602155404");
		inDDI.setExperimentID(exp.getUniqueid().intValue());
		inDDI.setVisitID(2);

		DerivedDataInfo outDDI = new DerivedDataInfo();
		outDDI
				.setDataURI("/home/bozyurt.ucsd-fmri/tmp/000602155404/scanVisit__0006__0002/MRI__0001/AudOdd1/Analysis/Original__0001/FIPS_MBTS_preprocs__0008__0001/M_mc-fsl.preproc/index.html");
		outDDI.setSubjectID("000602155404");
		outDDI.setExperimentID(exp.getUniqueid().intValue());
		outDDI.setVisitID(2);

		eti.addInputDerivedDataInfo(inDDI);
		eti.addOutputDerivedDataInfo(outDDI);

		List<ExecutedTransformInfo> etiList = new ArrayList<ExecutedTransformInfo>(
				1);
		etiList.add(eti);
		
		List<ExecutedTransformInfo> flowList = new ArrayList<ExecutedTransformInfo>(1);
		flowList.add(eti);
		
		ps.addExecutedTransforms(getUi(), etiList, flowList);
	}

	public void testGetMatchingExecutedTransforms() throws Exception {
		IProvenanceService ps = ServiceFactory.getProvenanceService(getDbID());
		Experiment exp = findExperiment("fBIRNPhaseII__0010");
		assertNotNull(exp);

		AnalysisInstanceDataResult aids = ps.getMatchingExecutedTransforms(
				getUi(), "000602155404", exp.getUniqueid().intValue(), null,
				null);
		assertNotNull(aids);
		System.out.println(aids);
	}

	private AnalysisCompInfo createACI(int id, int nodeLevel, AnalysisInfo ai,
			TransformationInfo ti, AnalysisCompInfo parent) {
		AnalysisCompInfo aci = new AnalysisCompInfo(id);
		aci.setTransform(ti);
		aci.setAnalysis(ai);
		aci.setNodeLevel(nodeLevel);
		aci.setParent(parent);
		return aci;
	}

	public static TestSuite suite() throws IOException {
		TestSuite s = new TestSuite();
		s.addTest(new ProvenanceTests("testAddAnalysis"));
		// s.addTest(new ProvenanceTests("testAddETIs"));
		// s.addTest(new ProvenanceTests("testGetMatchingExecutedTransforms"));
		// s.addTest( new ProvenanceTests("testDeleteMatchingExecutedTransforms"));
		// s.addTest( new ProvenanceTests("testDeleteAnalysis"));
		return s;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}
}
