package clinical.test;

import java.util.List;
import java.util.Map;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import clinical.web.common.AssessmentMapping;
import clinical.web.common.MediatedQueryHelper;

public class SiteAsMappingTest extends TestCase {
   public SiteAsMappingTest(String name) {
      super(name);
   }

   public void testAsMapLoading() throws Exception {
      String mappingFile = "/home/bozyurt/dev/java/clinical/conf/as_var_map.xml";
      Map<Integer, List<AssessmentMapping>> siteAsMap = MediatedQueryHelper
            .prepareAssesmentMapping(mappingFile);
      for (List<AssessmentMapping> amList : siteAsMap.values()) {
         for (AssessmentMapping am : amList) {
            System.out.println(am.getFirstDB() + " name=" + am.getName()
                  + " second db=" + am.getSecondDB());
         }
      }
   }

   public static TestSuite suite() {
      TestSuite suite = new TestSuite();

      suite.addTest(new SiteAsMappingTest("testAsMapLoading"));
      return suite;
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }

}