package clinical.test;

import java.util.HashMap;
import java.util.Map;

/**
 * @author I. Burak Ozyurt
 * @version $Id: TestCaseInfo.java 365 2011-05-05 20:04:18Z bozyurt $
 */
public class TestCaseInfo {
	String name;
	Map<String, QueryRequestInfo> queryRequestInfoMap = new HashMap<String, QueryRequestInfo>();
	Map<String, ResponseInfo> responseMap = new HashMap<String, ResponseInfo>();

	public TestCaseInfo() {
	}

	public void addResponse(ResponseInfo ri) {
		responseMap.put(ri.getTitle(), ri);
	}

	public void addQueryRequestInfo(QueryRequestInfo qri, String prevQriName) {
		QueryRequestInfo prevQri = getQueryRequestInfo(prevQriName);
		qri.setPrevious(prevQri);
		queryRequestInfoMap.put(qri.getName(), qri);
	}

	public QueryRequestInfo getQueryRequestInfo(String name) {
		return queryRequestInfoMap.get(name);
	}

	public ResponseInfo getResponseInfo(String title) {
		return (ResponseInfo) responseMap.get(title);
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}
}