package clinical.test;

import java.io.IOException;

import junit.framework.TestSuite;
import clinical.utils.FileUtils;
import clinical.web.ServiceFactory;
import clinical.xml.export.XCEDE2SeriesExporter;

/**
 * @author I. Burak Ozyurt
 * @version $Id: XCEDE2ServiceImpTests.java,v 1.1.2.2 2008/06/10 21:52:04
 *          bozyurt Exp $
 */
public class XCEDE2ServiceImpTests extends MyDBTestCase {

   public XCEDE2ServiceImpTests(String testName) throws IOException {
      super(testName, "test.properties", true);
   }

   public void testImportAssessmentDataFromXCEDE() throws Exception {
      String dbID = getDbID();
      XCEDE2SeriesExporter ex = new XCEDE2SeriesExporter(dbID, ServiceFactory
            .getSQLDialect(dbID));

      String xcede = null;
      String protocolID = "Subjects screening protocol";
      int protocolVersion = 1;
      xcede = FileUtils
            .loadTextFile("c:/cygwin/home/bozyurt/work/4tablet/BIRN/clinical/conf/ses.xcede");
      ex.importAssessmentDataFromXCEDE(getUi(), getDbID(), xcede, protocolID,
            protocolVersion);
   }

   public static TestSuite suite() throws IOException {
      TestSuite s = new TestSuite();
      s.addTest(new XCEDE2ServiceImpTests("testImportAssessmentDataFromXCEDE"));
      return s;
   }

   public static void main(String[] args) throws IOException {
      junit.textui.TestRunner.run(suite());
   }

}
