package clinical.test.cbf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import clinical.utils.AFNIHeaderReader;
import clinical.utils.Field;
import clinical.utils.GenUtils;
import clinical.utils.HeaderFields;
import clinical.utils.PFileHeaderUtils;
import clinical.web.vo.HeaderFieldType;

import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CBFHeaderFieldUtilsTests.java 365 2011-05-05 20:04:18Z bozyurt $
 */
public class CBFHeaderFieldUtilsTests extends TestCase {
	Properties props;
	List<File> pfiles = new ArrayList<File>();
	List<File> afniFiles = new ArrayList<File>();

	public CBFHeaderFieldUtilsTests(String testName) throws Exception {
		super(testName);
		props = GenUtils.loadProperties("test.properties");
		assertNotNull(props);
	}

	protected void setUp() throws Exception {
		String rootDir = props.getProperty("cbf.header.field.test.rootdir");
		File[] dirFiles = new File(rootDir).listFiles();
		for (File dirFile : dirFiles) {
			if (dirFile.isDirectory()) {
				File[] files = dirFile.listFiles();
				for (File file : files) {
					if (file.getName().endsWith(".7")) {
						pfiles.add(file);
					} else if (file.getName().endsWith(".HEAD")) {
						afniFiles.add(file);
					}
				}
			}
		}
		super.setUp();
	}

	public void testPFileHeaderExtraction() throws Exception {
		for (File pfile : pfiles) {
			System.out.println("pfile:" + pfile);
			System.out
					.println("=====================================================");
			PFileHeaderUtils phu = new PFileHeaderUtils(pfile.getAbsolutePath());
			phu.readHeader();
		}
	}

	public void testAFNIHeaderExtraction() throws Exception {
		List<HeaderFieldType> hftList = new ArrayList<HeaderFieldType>(5);
		hftList.add(new HeaderFieldType("tag", HeaderFieldType.INT));
		hftList.add(new HeaderFieldType("timestamp", HeaderFieldType.STRING,
				"NOTE_DATE_001"));

		hftList.add(new HeaderFieldType("reps", HeaderFieldType.INT));
		hftList.add(new HeaderFieldType("dda", HeaderFieldType.INT));
		hftList.add(new HeaderFieldType("nIntlv", HeaderFieldType.INT));
		hftList.add(new HeaderFieldType("speprev", HeaderFieldType.STRING));
		hftList.add(new HeaderFieldType("mpphase", HeaderFieldType.INT));
		hftList.add(new HeaderFieldType("mppcasl", HeaderFieldType.INT));

		for (File afniHeader : afniFiles) {
			System.out.println("AFNI header:" + afniHeader);
			System.out
					.println("=====================================================");
			AFNIHeaderReader ahr = new AFNIHeaderReader(afniHeader
					.getAbsolutePath());
			ahr.readHeader();
			HeaderFields hf = ahr.extractFields(hftList);
			Field<Integer> tagField = hf.getIntField("tag");
			Field<Integer> repsField = hf.getIntField("reps");
			Field<Integer> ddaField = hf.getIntField("dda");
			Field<Integer> nIntlvField = hf.getIntField("nIntlv");
			Field<String> speprevField = hf.getStringField("speprev");
			Field<Integer> mpphaseField = hf.getIntField("mpphase");
			Field<Integer> mppcaslField = hf.getIntField("mppcasl");
			
			Field<String> tsField = hf.getStringField("timestamp");

			System.out.println("timestamp:" + tsField);
			System.out.println("tag:" + tagField);
			System.out.println("reps:" + repsField);
			System.out.println("dda:" + ddaField);
			System.out.println("nIntlv:" + nIntlvField);

			System.out.println("speprev:" + speprevField);
			System.out.println("mpphase:" + mpphaseField);
			System.out.println("mppcasl:" + mppcaslField);

		}
	}

	public static TestSuite suite() throws Exception {
		TestSuite suite = new TestSuite();
		//suite.addTest(new CBFHeaderFieldUtilsTests(
		//				"testPFileHeaderExtraction"));
		suite.addTest(new CBFHeaderFieldUtilsTests("testAFNIHeaderExtraction"));
		return suite;
	}

	public static void main(String[] args) throws Exception {
		junit.textui.TestRunner.run(suite());
	}
}
