package clinical.test.cbf;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestSuite;

import org.jdom.CDATA;
import org.jdom.Element;

import clinical.server.dao.JobsDAO;
import clinical.server.vo.Deriveddata;
import clinical.server.vo.Jobs;
import clinical.test.MyTestCase;
import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.web.DAOFactory;
import clinical.web.common.UserInfo;
import clinical.web.download.FileBundleConfig;
import clinical.web.download.Packager;
import clinical.web.download.PathWrapper;
import clinical.web.services.SecurityService;
import clinical.web.vo.upload.VisitInfo;
import clinical.web.workflow.cbf.CBFProcJobHelper;
import clinical.web.workflow.cbf.CBFWFContext;
import clinical.web.workflow.cbf.VisitProcessInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CBFJobManTests.java 365 2011-05-05 20:04:18Z bozyurt $
 */
public class CBFJobManTests extends MyTestCase {
	CBFWFContext ctx;
	VisitProcessInfo vpi;

	public CBFJobManTests(String testName, String propsFile) throws IOException {
		super(testName, propsFile, true);
	}

	@Override
	protected void setUp() throws Exception {
		// TODO Auto-generated method stub
		String homeDir = System.getProperty("user.home");
		File serFile = new File(homeDir, "CBFWFContext.ser");

		this.ctx = (CBFWFContext) FileUtils.deserialize(serFile
				.getAbsolutePath());

		File vpiSerFile = new File(homeDir, "vpi.ser");
		vpi = (VisitProcessInfo) FileUtils.deserialize(vpiSerFile
				.getAbsolutePath());

		super.setUp();

		SecurityService ss = SecurityService.getInstance(getDbPoolService(),
				getDbID(), super.mixin.getDbType());
		ss.startup();
	}

	public void testXMLEscape4JobErrors() throws Exception {
		Connection con = null;
		try {
			con = super.getConnection();
			JobsDAO dao = DAOFactory.createJobsDAO(getDbID());
			Jobs cr = new Jobs();
			cr.setJobid("1271940849319");
			List<Jobs> jobsList = dao.find(con, cr);
			Jobs job = jobsList.get(0);

			Element el = new Element("err");
			// String x = job.getErrormsg();
			String stripped = job.getErrormsg().replaceAll("\\p{Cntrl}", "");
			CDATA cd = new CDATA(stripped);
			el.addContent(cd);

		} finally {
			releaseConnection(con);
		}
	}

	public static String extractRootDir(String datauri, String subjectID) {
		String[] parts = datauri.split("\\/+");
		int idx = -1;
		for (int i = 0; i < parts.length; i++) {
			if (parts[i].equals(subjectID)) {
				idx = i - 1;
			}
		}
		Assertion.assertTrue(idx > 0);
		int lidx = datauri.indexOf(parts[idx]);
		String srcRoot = datauri.substring(0, lidx);
		srcRoot = srcRoot.replaceFirst("\\/+$", "");
		return srcRoot;
	}

	public void testSaveDerivedData() throws Exception {
		UserInfo ui = new UserInfo("dshin", null, null);
		CBFProcJobHelper helper = new CBFProcJobHelper(ui, ctx, null);
		List<Deriveddata> ddList = helper.saveDerivedData(vpi);
		// final packaging

		List<Deriveddata> matDDList = new ArrayList<Deriveddata>(10);
		for (Deriveddata dd : ddList) {
			if (dd.getDatauri().endsWith(".mat")) {
				matDDList.add(dd);
			}
		}

		SimpleDateFormat sdf = new SimpleDateFormat("MM_dd_yyyy");
		VisitInfo vi = ctx.getViList().get(0);
		String subjectID = vi.getSubjectID();

		String bundleName = subjectID + "_Visit_"
				+ sdf.format(vi.getVisitDate());

		String srcRootDir = null;
		List<PathWrapper> allFiles = new ArrayList<PathWrapper>();
		for (Deriveddata dd : matDDList) {
			String datauri = dd.getDatauri();
			if (srcRootDir == null) {
				srcRootDir = extractRootDir(datauri, subjectID);
			}
			String relativePath = FileUtils
					.getRelativePath(srcRootDir, datauri);
			PathWrapper pw = new PathWrapper(relativePath, srcRootDir);
			allFiles.add(pw);
		}

		Packager p = new Packager(ctx.getCacheDir(), bundleName,
				FileBundleConfig.GZIPPED);

		p.includeFiles(allFiles);
		p.pack();
	}

	public static TestSuite suite() throws Exception {
		TestSuite suite = new TestSuite();
	//	suite.addTest(new CBFJobManTests("testSaveDerivedData",
	//			"test.properties"));
		suite.addTest(new CBFJobManTests("testXMLEscape4JobErrors",
				"test.properties"));
		return suite;
	}

	public static void main(String[] args) throws Exception {
		junit.textui.TestRunner.run(suite());
	}
}
