package clinical.test.cbf;

import java.util.List;
import java.util.Map;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import clinical.web.ConnectionSupportMixin;
import clinical.web.ICBFWFManagementService;
import clinical.web.common.UserInfo;
import clinical.web.services.CBFWFManagementService;
import clinical.web.services.SecurityService;
import clinical.web.vo.upload.VisitInfo;

public class CBWFManServiceTests extends TestCase {
	protected ConnectionSupportMixin csm;

	public CBWFManServiceTests(String testName) {
		super(testName);
	}
	
	protected void setUp() throws Exception {
		csm = new ConnectionSupportMixin("users.xml");
		csm.startup();
		SecurityService ss = SecurityService.getInstance(csm.getDbPoolService(),
				csm.getDbID(), csm.getDbType());
		ss.startup();
		// MinimalServiceFactory.setMimimalOpMode(true);
		super.setUp();
	}
	
	protected void tearDown() throws Exception {
		if (csm != null) {
			csm.shutdown();
		}
		super.tearDown();
	}
	
	public void testGetScanVisits() throws Exception {
		ICBFWFManagementService wfService = new CBFWFManagementService(csm
				.getDbID());
		// SecurityService ss = (SecurityService) ServiceFactory
		// .getSecurityService();
		// DBConfig dbConfig = ss.getDBConfigMap().get(csm.getDbID());
		UserInfo ui = new UserInfo("dshin", null, null);
		Map<String, List<VisitInfo>> scanVisitsMap = wfService
				.getScanVisits(ui);
		for (String expName : scanVisitsMap.keySet()) {
			System.out.println("expName:" + expName);
			List<VisitInfo> list = scanVisitsMap.get(expName);
			
            list = wfService.getVisitInfosWithScans(ui, list);
			for (VisitInfo vi : list) {
				System.out.println(vi.getSubjectID() + " visitId:"
						+ vi.getVisitId() + " visitDate:" + vi.getVisitDate());
				System.out.println(vi);
			}
		}
	}
	
	
	
	public static TestSuite suite()  {
		TestSuite s = new TestSuite();
	
		s.addTest(new CBWFManServiceTests("testGetScanVisits"));
		return s;
	}
	
	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}
}
