package clinical.tools.dbadmin;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import clinical.tools.dbadmin.AssessmentManAdmin.AssessmentDataWrapper;
import clinical.web.DBUtils;
import clinical.web.vo.upload.ScoreValue;

public class AsManHelper {

	public static void delAssessmentValues(Connection con, BigDecimal saID)
			throws Exception {
		delAssessmentValues(con, "nc_assessmentinteger", saID);
		delAssessmentValues(con, "nc_assessmentvarchar", saID);
		delAssessmentValues(con, "nc_assessmentfloat", saID);
		delAssessmentValues(con, "nc_assessmenttimestamp", saID);
		delAssessmentValues(con, "nc_assessmentboolean", saID);
		delAssessmentValues(con, "nc_assessmentinteger", saID);
	}

	private static void delAssessmentValues(Connection con, String tableName,
			BigDecimal saID) throws Exception {
		PreparedStatement pst = null;
		try {
			pst = con.prepareStatement("delete from " + tableName
					+ " where storedassessmentid = ?");
			pst.setBigDecimal(1, saID);

			pst.executeUpdate();
		} finally {
			DBUtils.close(pst);
		}
	}

	public static void checkForDuplicateAssessments(
			List<AssessmentDataWrapper> adwList) {
		Map<String, List<AssessmentDataWrapper>> adwMap = new HashMap<String, List<AssessmentDataWrapper>>();

		for (AssessmentDataWrapper adw : adwList) {
			String key = prepKey(adw.subjectID, adw.at.getName(), adw.visitID);
			List<AssessmentDataWrapper> list = adwMap.get(key);
			if (list == null) {
				list = new ArrayList<AssessmentDataWrapper>(1);
				adwMap.put(key, list);
			}
			list.add(adw);
		}
		for (String key : adwMap.keySet()) {
			List<AssessmentDataWrapper> list = adwMap.get(key);
			if (list.size() > 1) {
				System.out.println("-------------------------------");
				AssessmentDataWrapper refADW = list.get(0);
				for (int i = 1; i < list.size(); i++) {
					AssessmentDataWrapper adw2 = list.get(i);
					boolean match = isSameAssessmentContent(refADW, adw2);
					if (match) {
						System.out.println(" score values match!\nadw1:"
								+ refADW + "\nadw2:" + adw2);
					}
					System.out.println("==========================");
				}
				System.out.println("-------------------------------");
			}
		}
	}

	public static boolean isSameAssessmentContent(AssessmentDataWrapper adw1,
			AssessmentDataWrapper adw2) {
		if (adw1.at.getSvList().size() != adw2.at.getSvList().size()) {
			System.out.println("Number of scores don't match!\nadw1:" + adw1
					+ "\nadw2:" + adw2);
			System.out.println("adw1 # scores:" + adw1.at.getSvList().size()
					+ " adw2 #scores:" + adw2.at.getSvList().size());
			// return false;
		}
		List<ScoreValue> svList = adw1.at.getSvList();
		Map<String, ScoreValue> svMap = new HashMap<String, ScoreValue>();
		for (ScoreValue sv : svList) {
			svMap.put(sv.getName(), sv);
		}
		boolean match = true;
		for (ScoreValue sv : adw2.at.getSvList()) {
			ScoreValue sv1 = svMap.get(sv.getName());
			if (sv1 == null) {
				match = false;
			}
			if (!sv1.getValue().equals(sv.getValue())) {
				System.out.println(adw1.subjectID +  ":: score " + sv.getName()
						+ " mismatched value! adw1:" + sv.getValue() + " adw2:"
						+ sv1.getValue());
				match = false;
			}
		}
		return match;
	}

	static String prepKey(String subjectID, String asName, BigDecimal visitID) {
		StringBuilder sb = new StringBuilder();
		sb.append(subjectID).append(':').append(asName);
		sb.append(':').append(visitID);
		return sb.toString();
	}
}
