package clinical.tools.dbadmin;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CUDPanel extends JPanel implements ActionListener,
		PropertyChangeListener {
	private static final long serialVersionUID = 1;
	JButton addButton = new JButton("Add");
	JButton updateButton = new JButton("Update");
	JButton deleteButton = new JButton("Delete");
	JTextField[] fields;
	List<String> columns;
	AdminController ac;
	PropertyChangeSupport pcs;
	Map<String, Object> recordMap;
	String voName;

	public CUDPanel(String voName, List<String> columns, AdminController ac) {
		this.voName = voName;
		this.columns = columns;
		this.ac = ac;
		pcs = new PropertyChangeSupport(this);
		setLayout(new BorderLayout(5, 5));
		setBorder(BorderFactory.createTitledBorder("Manage Record"));
		JPanel labelPanel = new JPanel(new GridLayout(columns.size(), 1, 5, 5));
		JPanel fieldPanel = new JPanel(new GridLayout(columns.size(), 1, 5, 5));

		fields = new JTextField[columns.size()];
		int i = 0;
		for (String col : columns) {
			labelPanel.add(new JLabel(col, JLabel.RIGHT));
			fields[i] = new JTextField();
			fieldPanel.add(fields[i]);
			i++;
		}
		JPanel p = new JPanel(new BorderLayout(5, 5));
		p.add(labelPanel, BorderLayout.WEST);
		p.add(fieldPanel, BorderLayout.CENTER);

		addButton.addActionListener(this);
		updateButton.addActionListener(this);
		deleteButton.addActionListener(this);
		JPanel buttonPanel = new JPanel();
		BoxLayout bl = new BoxLayout(buttonPanel, BoxLayout.X_AXIS);
		buttonPanel.setLayout(bl);
		buttonPanel.add(Box.createHorizontalGlue());
		buttonPanel.add(addButton);
		buttonPanel.add(Box.createHorizontalStrut(5));
		buttonPanel.add(updateButton);
		buttonPanel.add(Box.createHorizontalStrut(5));
		buttonPanel.add(deleteButton);
		buttonPanel.add(Box.createHorizontalStrut(5));

		JPanel mainPanel = new JPanel(new BorderLayout(5, 5));

		mainPanel.add(p, BorderLayout.CENTER);
		mainPanel.add(buttonPanel, BorderLayout.SOUTH);
		add(mainPanel, BorderLayout.NORTH);

	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == addButton) {
			Map<String, Object> argMap = new HashMap<String, Object>(17);
			updateArgMap(argMap);
			ac.add(voName, argMap);
			pcs.firePropertyChange("update", false, true);
		}
		if (e.getSource() == deleteButton && this.recordMap != null) {
			int rc = JOptionPane.showConfirmDialog(this,
					"Do you really want delete this record?");
			System.out.println("rc=" + rc);
			if (rc == JOptionPane.YES_OPTION) {
				ac.delete(voName, prepArgMap(recordMap, true));
				pcs.firePropertyChange("update", false, true);
			}
		}
		if (e.getSource() == updateButton && this.recordMap != null) {
			Map<String, Object> argMap = prepArgMap(recordMap, true);
			updateArgMap(argMap);
			ac.update(voName, argMap);
			pcs.firePropertyChange("update", false, true);
		}
	}

	protected void updateArgMap(Map<String, Object> argMap) {
		for (int i = 0; i < columns.size(); i++) {
			String text = fields[i].getText().trim();
			if (!Utils.isNumber(text)) {
				argMap.put(columns.get(i), "'" + text + "'");
			} else {
				argMap.put(columns.get(i), text);
			}
		}
	}

	public static Map<String, Object> prepArgMap(Map<String, Object> amap,
			boolean removeDateFields) {
		Map<String, Object> argMap = new HashMap<String, Object>(17);
		for (String key : amap.keySet()) {
			String value = amap.get(key).toString();
			if (removeDateFields && key.indexOf("modtime") != -1) {
				continue;
			} else if (value != null) {
				if (!Utils.isNumber(value)) {
					argMap.put(key, "'" + value + "'");
				} else {
					argMap.put(key, value);
				}
			}
		}
		return argMap;
	}

	@SuppressWarnings("unchecked")
	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals("record")) {
			this.recordMap = (Map<String, Object>) evt.getNewValue();
			for (int i = 0; i < columns.size(); i++) {
				Object value = recordMap.get(columns.get(i));
				if (value != null) {
					fields[i].setText(value.toString());
				} else {
					fields[i].setText("");
				}
			}
		}
	}

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		pcs.addPropertyChangeListener(listener);
	}

}
