package clinical.tools.dbadmin;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.swing.JPanel;
import javax.swing.JSplitPane;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DataObjectTypeAdminView.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class DataObjectTypeAdminView extends JPanel implements PropertyChangeListener{
	private static final long serialVersionUID = 1L;
	AdminController ac;
	ListPanel lp;
	CUDPanel cudPanel;
	List<String> colNames;

	public DataObjectTypeAdminView(AdminController ac) {
		this.ac = ac;
		setLayout(new BorderLayout(5, 5));
		List<Map<String, Object>> list = ac.find("DataObjectType");
		colNames = new ArrayList<String>(10);
		colNames.add("objecttype");
		colNames.add("description");

		lp = new ListPanel(colNames, list);
		cudPanel = new CUDPanel("DataObjectType", colNames, ac);
		lp.addPropertyChangeListener(cudPanel);
		cudPanel.addPropertyChangeListener(this);

		JSplitPane sp = new JSplitPane(JSplitPane.VERTICAL_SPLIT, lp, cudPanel);
		sp.setOneTouchExpandable(true);
		sp.setDividerLocation(400);
		add(sp, BorderLayout.CENTER);
		
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals("update")) {
			System.out.println("received update property change event!");
			List<Map<String, Object>> list = ac.find("DataObjectType");
			lp.updateModel(colNames, list);			
		}
		
	}

}
