package clinical.tools.dbadmin;

import guilib.common.BaseDialog;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: GridFtpLoginDialog.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class GridFtpLoginDialog extends BaseDialog {
	JTextField myproxyHostField;
	JTextField gridFtpHostField;
	JTextField usernameField;
	JPasswordField pwdField;
	Map<String, String> stateMap;
	private static final long serialVersionUID = 1L;

	public GridFtpLoginDialog(Frame owner, String title,
			Map<String, String> stateMap) {
		super(owner, title, new String[] { "OK", "Cancel" });
		this.stateMap = stateMap;
		init();
		pack();
	}

	protected void init() {
		JPanel lp = new JPanel(new GridLayout(4, 1, 5, 5));
		JPanel fp = new JPanel(new GridLayout(4, 1, 5, 5));
		lp.add(new JLabel("Myproxy Host:", JLabel.RIGHT));
		lp.add(new JLabel("GridFTP Host:", JLabel.RIGHT));
		lp.add(new JLabel("Myproxy User:", JLabel.RIGHT));
		lp.add(new JLabel("Passphrase:", JLabel.RIGHT));

		myproxyHostField = new JTextField(getFieldState("myproxyHost",
				"certs.nbirn.org"));
		gridFtpHostField = new JTextField(getFieldState("gridFtpHost", null));
		usernameField = new JTextField(getFieldState("username", null));
		pwdField = new JPasswordField();

		fp.add(myproxyHostField);
		fp.add(gridFtpHostField);
		fp.add(usernameField);
		fp.add(pwdField);
		JPanel p = new JPanel(new BorderLayout(5, 5));

		p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		p.add(lp, BorderLayout.WEST);
		p.add(fp, BorderLayout.CENTER);

		getContentPane().add(p);
	}

	String getFieldState(String fieldName, String defaultValue) {
		String value = stateMap.get(fieldName);
		if (value == null) {
			return defaultValue != null ? defaultValue : "";
		}
		return value;
	}

	public String getGridFtpHost() {
		String value = gridFtpHostField.getText().trim();
		stateMap.put("gridFtpHost", value);
		return value;
	}

	public String getMyProxyHost() {
		String value = myproxyHostField.getText().trim();
		stateMap.put("myproxyHost", value);
		return value;
	}

	public String getUsername() {
		String value = usernameField.getText().trim();
		stateMap.put("username", value);
		return value;
	}

	String getPwd() {
		return new String(pwdField.getPassword());
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		this.returnCode = NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {
				this.returnCode = OK_PRESSED;
			}
		}
		setVisible(false);
	}
}
