package clinical.tools.install;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * @author I. Burak Ozyurt
 * @version $Id: BootstrapFileCreatorTask.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class BootstrapFileCreatorTask extends Task {
	String usersFile;

	public void setUsersFile(String newFile) {
		this.usersFile = newFile;
	}

	@Override
	public void execute() {
		MinimalUserFileCreator muc = null;
		try {
			if (usersFile == null) {
				throw new BuildException("The attribute 'usersFile' is not set!");
			}
			muc = new MinimalUserFileCreator( getProject() );
			muc.prepareUsersFile(usersFile);
		} catch (Exception x) {
			x.printStackTrace();
			throw new BuildException(x.getMessage());
		}
	}
}
