package clinical.tools.install;

import org.jdom.Element;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DatabaseInfo.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class DatabaseInfo {
	String dbID;
	String hostName;
	String dbType = "oracle";
	String SID = "orcl1";
	int port = 1521;
	boolean defaultDB = false;
	String siteId;
	String siteName;

	public String getDBURL() {
		StringBuffer buf = new StringBuffer(128);
		if (dbType.equalsIgnoreCase("oracle")) {
			buf.append("jdbc:").append(dbType).append(":thin:@").append(hostName)
					.append(":");
			buf.append(port).append(":").append(SID);
		} else if (dbType.equalsIgnoreCase("postgres")) {
			buf.append("jdbc:postgresql://").append(hostName);
			buf.append(":").append(port);
			buf.append("/").append(SID);
		} else {
			throw new RuntimeException("Not a supported DB type:" + dbType);
		}
		return buf.toString();
	}

	public void toXML(Element parent) {
		Element e = new Element("database");
		parent.addContent(e);
		e.setAttribute("id", dbID);
		e.setAttribute("default", defaultDB ? "true" : "false");
		e.setAttribute("siteId", siteId);
		e.setAttribute("siteName", siteName);
		Element ue = new Element("db-url");
		String dbURL = null;
		if (dbType.equalsIgnoreCase("oracle")) {
			dbURL = "jdbc:" + dbType + ":thin:@" + hostName + ":" + port + ":"
					+ SID;
		} else {
			dbURL = "jdbc:postgresql://" + hostName + ":" + port + "/" + SID;
		}
		ue.addContent(dbURL);
		e.addContent(ue);
		Element dbTypeElem = new Element("db-type");
		dbTypeElem.addContent(dbType.toLowerCase());
		e.addContent(dbTypeElem);
	}
}