package clinical.tools.install;

import org.jdom.Element;

public class PrivilegeInfo {
	String name;
	String description;
	boolean projectSpecific;

	public PrivilegeInfo(String name, String description, boolean projectSpecific) {
		this.name = name;
		this.description = description;
		this.projectSpecific = projectSpecific;
	}

	public void toXML(Element parent) {
		Element e = new Element("privilege");
		parent.addContent(e);
		e.setAttribute("name", name);
		if ( projectSpecific) {
			e.setAttribute("project-specific","true");
		} else {
			e.setAttribute("project-specific","false");
		}
		if (description != null) {
			Element de = new Element("description");
			de.addContent(description);
			e.addContent(de);
		}
	}
}