package clinical.tools.maintenance;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import clinical.server.dao.StoredassessmentDAO;
import clinical.server.vo.Assessment;
import clinical.server.vo.Storedassessment;
import clinical.web.DAOFactory;
import clinical.web.common.UserInfo;

public class StoredAssessmentFixer {
	public StoredAssessmentFixer() {
	}

	public static void testSA(String dbID, Connection con) throws Exception {
		Storedassessment sa = new Storedassessment();
		sa.setAssessmentid(new BigDecimal("2098"));
		StoredassessmentDAO dao = DAOFactory.createStoredassessmentDAO(dbID);
		List<Storedassessment> results = dao.find(con, sa);
		for (Storedassessment item : results) {
			System.out.println(item.toString());
		}
	}

	public static Map<String, Set<BigDecimal>> groupSARecs(List<?> results) {
		Map<String, Set<BigDecimal>> map = new HashMap<String, Set<BigDecimal>>();
		for (Iterator<?> iter = results.iterator(); iter.hasNext();) {
			Storedassessment sa = (Storedassessment) iter.next();
			String key = createKey(sa);
			Set<BigDecimal> saIDSet = map.get(key);
			if (saIDSet == null) {
				saIDSet = new TreeSet<BigDecimal>();
				map.put(key, saIDSet);
			}
			saIDSet.add(sa.getUniqueid());
		}
		return map;
	}

	public static String createKey(Storedassessment sa) {
		StringBuffer sb = new StringBuffer();
		sb.append(sa.getAssessmentid()).append('_');
		sb.append(sa.getNcExperimentUniqueid()).append('_');
		sb.append(sa.getSubjectid()).append('_');
		sb.append(sa.getComponentid()).append('_');
		sb.append(sa.getSegmentid());
		return sb.toString();
	}

	public static BigDecimal getFirstID(Set<BigDecimal> saIDSet) {
		for (Iterator<?> iter = saIDSet.iterator(); iter.hasNext();) {
			BigDecimal saID = (BigDecimal) iter.next();
			return saID;
		}
		return null;
	}

	public static void cleanupAssessmentValues(GenericDBAccessHelper helper,
			String asID) throws Exception {

		List<?> results = helper.find("Storedassessment", new String[] {
				"assessmentid", asID });
		// helper.dumpResults(results);

		Map<String, Set<BigDecimal>> saMap = groupSARecs(results);
		for (Iterator<Set<BigDecimal>> iter = saMap.values().iterator(); iter.hasNext();) {
			Set<BigDecimal> saIDSet = iter.next();

			BigDecimal firstSAID = getFirstID(saIDSet);
			saIDSet.remove(firstSAID);
			System.out.println("first SAID=" + firstSAID);
			for (BigDecimal saID : saIDSet) {
			
				helper.update("Assessmentinteger", new String[] {
						"storedassessmentid", firstSAID.toString() }, // update
																		// args
						new String[] { "storedassessmentid", saID.toString() });

				helper.update("Assessmentfloat", new String[] {
						"storedassessmentid", firstSAID.toString() }, // update
																		// args
						new String[] { "storedassessmentid", saID.toString() });

				helper.update("Assessmentvarchar", new String[] {
						"storedassessmentid", firstSAID.toString() }, // update
																		// args
						new String[] { "storedassessmentid", saID.toString() });

				/*
				 * helper.update("Assessmentdata", new String[] {
				 * "ncStoredassessmentUniqueid", firstSAID.toString() }, //
				 * update args new String[]
				 * {"ncStoredassessmentUniqueid",saID.toString()});
				 */

				// List rs = helper.find("Assessmentinteger", new String[]
				// {"storedassessmentid",saID.toString()} );
				// helper.dumpResults(rs);
			}
		}
	}

	public static void main(String[] args) {
		GenericDBAccessHelper helper = null;
		UserInfo ui = null;

		try {
			String usersFile = "/data1/opt/tomcat-4.1.24/webapps/clinical/WEB-INF/users.xml";

			helper = new GenericDBAccessHelper("test_mbirn", usersFile);
			ui = helper.getUserInfo();

			List<?> assessments = helper.find("Assessment", null);

			for (Iterator<?> iter = assessments.iterator(); iter.hasNext();) {
				Assessment as = (Assessment) iter.next();
				String asID = as.getAssessmentid().toString();

				cleanupAssessmentValues(helper, asID);
			}

			AbstractHelper.commit(ui);
		} catch (Exception x) {
			x.printStackTrace();
			AbstractHelper.rollback(ui);
		} finally {
			AbstractHelper.shutdown();
		}

	}

}