package clinical.upload;

import java.util.*;
import java.text.SimpleDateFormat;
import java.text.ParseException;

public class DateHandler implements IDataHandler {
  protected SimpleDateFormat df;
  protected String format;


  public DateHandler() {}

  //---------------------- setters --------------
  public void setFormat(String newFormat) {
    this.format = newFormat;
    df = new SimpleDateFormat(format);
  }

  //---------------------- getters --------------
  public String getFormat() { return this.format; }

  public Date convert(String rawValue) {
    if (rawValue instanceof String) {
      try {
        return df.parse((String) rawValue);
      } catch(ParseException x) {
        x.printStackTrace();
        return null;
       }
    }
    return null;
  }

  public Object convertToSQL(String value, String sqlType) throws DataConversionException {
    if (sqlType.equals("varchar")) {
         return value;
    } else if (sqlType.equals("date")) {
       Date date = convert(value);
       if (date == null)
          throw new   DataConversionException("Cannot convert "+ value + " to date!");
       return date;
    } else {
      throw new DataConversionException("Cannot convert "+ value + " to sql type "+ sqlType);
    }
  }
}