package clinical.upload;

import java.io.*;
import org.jdom.*;
import org.xml.sax.SAXException;

import org.apache.log4j.Logger;


public class ExperimentLoader {
  protected String metaFilename;
  protected String dataFilename;
  protected MetaDataLoader metaLoader;
  protected DataLoader dataLoader;
  protected static Logger logger = Logger.getLogger(ExperimentLoader.class);

  public ExperimentLoader() {}

  public ExperimentLoader(String metaFilename, String dataFilename) throws JDOMException, IOException {
    this.metaFilename = metaFilename;
    this.dataFilename = dataFilename;
    metaLoader = new MetaDataLoader(metaFilename);
  }

  public void loadData() throws IOException, SAXException {
    metaLoader.parse();
    logger.info("loaded assesment metadata.");
    dataLoader = new DataLoader(dataFilename, metaLoader, 15);
    dataLoader.loadData();
    logger.info("loaded assesment data.");
    dataLoader.dumpData();
  }


}