package clinical.upload;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

import clinical.server.dao.CollectionequipmentDAO;
import clinical.server.dao.RawdataDAO;
import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Rawdata;
import clinical.web.DAOFactory;
import clinical.web.DBUtils;
import clinical.web.ServiceFactory;

/**
 * 
 * uploads the image data information to the database
 * 
 * @author I. Burak Ozyurt
 * @version $Id: RawDataLoader.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class RawDataLoader {
	Properties props;
	String modUser;
	String owner;
	String dbID;

	public RawDataLoader(Properties props) {
		this.props = props;
	}

	public List<Expsegment> getSegmentsForRawData(Connection con,
			List<String> subjectIDList, int experimentID, String visitType)
			throws SQLException {
		List<Expsegment> segments = new LinkedList<Expsegment>();
		StringBuffer buf = new StringBuffer(256);
		buf.append("select a.segmentid, a.componentid, a.subjectid, a.protocolversion, a.protocolid");
		buf.append(" from nc_expsegment a, nc_expcomponent b");
		buf.append(" where a.componentid= b.componentid and a.subjectid = b.subjectid");
		buf.append("and b.nc_experiment_uniqueid = ").append(experimentID)
				.append(" and b.visittype='");
		buf.append(visitType).append("'"); // and b.subjectid in (");
		if (!subjectIDList.isEmpty()) {
			buf.append("and b.subjectid in (");
			for (Iterator<String> iter = subjectIDList.iterator(); iter
					.hasNext();) {
				String subjectID = iter.next();
				buf.append("'").append(subjectID).append("'");
				if (iter.hasNext())
					buf.append(',');
			}

			buf.append(')');
		}
		Statement st = null;
		try {
			st = con.createStatement();
			ResultSet rs = st.executeQuery(buf.toString());
			while (rs.next()) {
				Expsegment segment = new Expsegment();
				segment.setSegmentid(rs.getBigDecimal(1));
				segment.setComponentid(rs.getBigDecimal(2));
				segment.setSubjectid(rs.getString(3));
				segment.setProtocolversion(rs.getBigDecimal(4));
				segment.setProtocolid(rs.getString(5));
				segment.setNcExperimentUniqueid(new BigDecimal(String
						.valueOf(experimentID)));
				segments.add(segment);
			}
			rs.close();
		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}
		return segments;
	}

	public Collectionequipment findCollectionEquipment(String dbID,
			Connection con, String make, String model) throws Exception {
		Collectionequipment criteria = new Collectionequipment();
		if (make != null && make.trim().length() > 0)
			criteria.setMake(make.trim());
		if (model != null && model.trim().length() > 0)
			criteria.setModel(model.trim());
		CollectionequipmentDAO dao = DAOFactory
				.createCollectionequipmentDAO(dbID);
		List<?> results = dao.find(con, criteria);
		if (results.isEmpty())
			return null;
		return (Collectionequipment) results.get(0);
	}

	public void insertRawDataRecord(String dbID, Connection con,
			Expsegment segment, String dataURI, Collectionequipment ce,
			String ontologySrc, String conceptID) throws Exception {
		Rawdata rawData = new Rawdata();
		rawData.setComponentid(segment.getComponentid());
		rawData.setSegmentid(segment.getSegmentid());
		rawData.setSubjectid(segment.getSubjectid());
		rawData.setProtocolid(segment.getProtocolid());
		rawData.setProtocolversion(segment.getProtocolversion());
		rawData.setNcExperimentUniqueid(segment.getNcExperimentUniqueid());

		rawData.setDatauri(dataURI);

		rawData.setExtensionname("none");

		rawData.setIsraw(new Boolean(true));

		rawData.setModtime(new java.util.Date());
		Databaseuser ownerRec = DBUtils.getDatabaseUser(dbID, con, owner);
		Databaseuser modUserRec = ownerRec;
		if (!owner.equalsIgnoreCase(modUser)) {
			modUserRec = DBUtils.getDatabaseUser(dbID, con, modUser);
		}

		rawData.setOwner(ownerRec.getUniqueid());
		rawData.setModuser(modUserRec.getUniqueid());
		rawData.setConceptid(conceptID);
		rawData.setOntologysource(ontologySrc);

		rawData.setUniqueid(ServiceFactory.getSequenceHelper(this.dbID)
				.getNextUID(con, "nc_rawdata", "uniqueid"));

		RawdataDAO dao = DAOFactory.createRawdataDAO(dbID);
		dao.insert(con, rawData);
	}

}