package clinical.utils;

import java.io.File;
import java.util.List;


import clinical.web.services.CBFImageTypeLookupService;
import static clinical.web.CBFBIRNConstants.*;
/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class CBFImageTypeDecider  {
	CBFImageTypeLookupService service;
	public final static int FIELD_MAP1 = 1;
	public final static int FIELD_MAP2 = 2;
	public final static int FIELD_MAP_GRASS = 3;
	public final static int FIELD_MAP_NONE = -1;

	public CBFImageTypeDecider(CBFImageTypeLookupService service) {
		this.service = service;
	}

	public String findDicomSeriesType(String seriesDesc, File dicomDir) {
		if (seriesDesc == null) {
			return null;
		}
		List<String> matchingGroups = service.getMatchingGroups(seriesDesc,
				true);
		if (matchingGroups.isEmpty()) {
			return null;
		}
		if (matchingGroups.size() == 1) {
			String type = matchingGroups.get(0);
			if (type.equals(ANATOMICAL)) {
				return ANATOMICAL;
			} else if (type.equals(TOF)) {
				return TOF;
			} else if (type.equals(FIELD_MAP)) {
				return FIELD_MAP;
			} else if (type.equals(LOCALIZER)) {
				return LOCALIZER;
			} else if (type.equals(MINCON)) {
				return MINCON;
			} else if (type.equals(CSF)) {
				return CSF;
			} else if (type.equals(FAIR)) {
				return FAIR;
			} else if (type.equals(D3PCASL)) {
				return D3PCASL;
			}
		} else {
			if (containsBoth(matchingGroups, FAIR, CSF)) {
				// FIXME crude check needs to be refined
				File[] files = dicomDir.listFiles();
				int count = 0;
				for (File f : files) {
					if (f.isFile())
						count++;
				}
				if (count < 10) {
					return CSF;
				} else {
					return FAIR;
				}
			} else if (matchingGroups.contains(FIELD_MAP)) {
				return FIELD_MAP;
			}
		}
		return null;
	}

	public int getFieldMapNo(String seriesDesc, String directoryName) {
		List<String> matchingGroups = service.getMatchingGroups(seriesDesc,
				true);
		if (matchingGroups == null || matchingGroups.isEmpty()) {
			matchingGroups = service.getMatchingGroups(directoryName, true);
			if (matchingGroups != null && !matchingGroups.isEmpty()) {
				return getFieldMapNo(matchingGroups);
			}
		} else {
			int fmType = getFieldMapNo(matchingGroups);
			if (fmType == FIELD_MAP_NONE) {
				matchingGroups = service.getMatchingGroups(directoryName, true);
				if (matchingGroups != null && !matchingGroups.isEmpty()) {
					return getFieldMapNo(matchingGroups);
				}
			} else {
				return fmType;
			}
		}
		return FIELD_MAP_NONE;
	}

	private int getFieldMapNo(List<String> matchingGroups) {
		if (matchingGroups.contains("fm1")) {
			return FIELD_MAP1;
		} else if (matchingGroups.contains("fm2")) {
			return FIELD_MAP2;
		} else if (matchingGroups.contains("fm")) {
			return FIELD_MAP_GRASS;
		}
		return FIELD_MAP_NONE;
	}

	public static boolean containsBoth(List<String> list, String tok1,
			String tok2) {
		if (list.size() < 2) {
			return false;
		}
		boolean ok = true;
		ok &= list.contains(tok1);
		if (!ok)
			return false;
		ok &= list.contains(tok2);
		return ok;
	}
}
