/**
 * 
 */
package clinical.utils;

import java.util.HashMap;
import java.util.Map;

import clinical.web.vo.HeaderFieldType;

public class HeaderFields {
	Map<String, Field<Integer>> integerFieldMap = new HashMap<String, Field<Integer>>(
			37);
	Map<String, Field<String>> stringFieldMap = new HashMap<String, Field<String>>(
			37);
	Map<String, Field<Float>> floatFieldMap = new HashMap<String, Field<Float>>(
			37);
	Map<String, HeaderFieldType> headerFieldTypeMap = new HashMap<String, HeaderFieldType>(
			37);

	protected void addIntField(Field<Integer> field, HeaderFieldType hft) {
		integerFieldMap.put(hft.getName(), field);
		headerFieldTypeMap.put(hft.getName(), hft);
	}

	protected void addFloatField(Field<Float> field, HeaderFieldType hft) {
		floatFieldMap.put(hft.getName(), field);
		headerFieldTypeMap.put(hft.getName(), hft);
	}

	protected void addStringField(Field<String> field, HeaderFieldType hft) {
		stringFieldMap.put(hft.getName(), field);
		headerFieldTypeMap.put(hft.getName(), hft);
	}

	public Field<String> getStringField(String name) {
		return stringFieldMap.get(name);
	}

	public Field<Float> getFloatField(String name) {
		return floatFieldMap.get(name);
	}

	public Field<Integer> getIntField(String name) {
		return integerFieldMap.get(name);
	}

	public HeaderFieldType getFieldType(String name) {
		return headerFieldTypeMap.get(name);
	}

}