package clinical.web;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;

import clinical.event.SequenceCreateEventListener;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;

/**
 * Interface for sequence number retrieval from the database connected in a
 * database independent way.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ISequenceHelper.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public interface ISequenceHelper {

	/**
	 * returns the next sequence number. Assumes that there is a single sequence
	 * named <code>uid_seq</code>
	 * 
	 * @param con
	 *            JDBC connection
	 * @return the next unique number from the database sequence
	 * @throws SQLException
	 */
	public BigDecimal getNextUID(Connection con, String tableName,
			String columnName) throws BaseException;

	/**
	 * returns the next sequence number. Assumes that there is a single sequence
	 * named <code>uid_seq</code>
	 * 
	 * @param ui
	 *            User Information used to use the correct named database user
	 *            connection from the connection pool
	 * @return the next unique number from the database sequence
	 * @throws BaseException
	 */
	public BigDecimal getNextUID(UserInfo ui, String tableName,
			String columnName) throws BaseException;

	public void addListener(SequenceCreateEventListener lsnr);

	public void removeListener(SequenceCreateEventListener lsnr);

}