package clinical.web;

import java.util.List;

import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.vo.upload.UploadStatusInfo;
import clinical.web.vo.upload.VisitInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: IUploadManagementService.java 366 2011-05-05 20:06:27Z bozyurt
 *          $
 */
public interface IUploadManagementService {
	public final static String NOT_STARTED = "not_started";
	public final static String STAGED = "staged";
	public final static String UPLOADED = "uploaded";
	public final static String FINISHED_WITH_ERR = "finished_with_err";

	public UploadStatusInfo doUploadStaging(UserInfo ui, String stagingDirRoot,
			String tarBallName, String experimentName, String subjectID)
			throws Exception;

	public void uploadVisit(UserInfo ui, VisitInfo visitInfo, int stagingId)
			throws Exception;

	public List<AssessmentSelectionInfo> getAssessmentMetaData(UserInfo ui,
			String primarySiteID) throws Exception;
}
