package clinical.web;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.log4j.MDC;

public class UserLogServletFilter implements Filter {
	private final static String USER_KEY = "user";

	public void destroy() {
		// no op
	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		boolean userLoggedIn = false;
		HttpServletRequest req = (HttpServletRequest) request;
		HttpSession session = req.getSession();
		// System.out.println("**** in filter");
		if (session != null) {
			UserContainer userCon = (UserContainer) session
					.getAttribute(Constants.CONTAINER_KEY);
			if (userCon != null && userCon.getUserInfo() != null) {
				MDC.put(USER_KEY, userCon.getUserInfo().getPerceivedName());
				userLoggedIn = true;
				// System.out.println("filter:" + userCon.getUserInfo().getPerceivedName());
			}
		}

		try {
			chain.doFilter(request, response);
		} finally {
			if (userLoggedIn) {
				MDC.remove(USER_KEY);
			}
		}

	}

	@Override
	public void init(FilterConfig arg0) throws ServletException {
		// no op
	}

}
