package clinical.web.actions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONObject;

import clinical.utils.FileUtils;
import clinical.web.IAppConfigService;
import clinical.web.IUploadManagementService;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.services.AppConfigService;
import clinical.web.vo.upload.UploadStatusInfo;
import clinical.xml.ApplicationUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ASLUploadAction.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class ASLUploadAction extends Action {

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		String dbID = null;
		// IDBCache dbCache = null;
		try {
			System.out.println("in ASLUploadAction");
			dbID = getDBID();
			boolean isMultipart = ServletFileUpload.isMultipartContent(request);

			System.out.println("isMultipart:" + isMultipart);
			// dbCache = ServiceFactory.getDBCache(dbID);
			ServletFileUpload upload = new ServletFileUpload();
			FileItemIterator iter = upload.getItemIterator(request);
			String webUser = null;
			String pwd = null;
			Map<String, String> map = new HashMap<String, String>();
			UserInfo ui = null;

			IAppConfigService cs = AppConfigService.getInstance();
			String cacheRoot = cs.getParamValue("download.cacheroot");
			if (cacheRoot == null || !new File(cacheRoot).isDirectory()) {
				throw new Exception("Not a valid 'download.cacheroot' directory:"
						+ cacheRoot);
			}
			File workDir = new File(cacheRoot, "upload");
			if (!workDir.exists() || !workDir.isDirectory()) {
				boolean ok = workDir.mkdir();
				if (!ok) {
					throw new Exception("Cannot create directory:" + workDir);
				}
			}

			String localPath = null;

			// TODO assumption ONLY one file to upload
			String filename = null;
			String experimentName = null;
			String subjectID = null;
			while (iter.hasNext()) {
				System.out.println("have item");
				FileItemStream item = iter.next();
				String fieldName = item.getFieldName();
				System.out.println("fieldName= " + fieldName);
				if (item.isFormField()) {
					String value = Streams.asString(item.openStream());
					map.put(fieldName, value);

				} else {
					webUser = map.get("webUser");
					pwd = map.get("pwd");
					experimentName = map.get("experimentName");
					subjectID = map.get("subjectID");

					ui = ApplicationUtils.authenticate(webUser, pwd, dbID);

					filename = item.getName();
					System.out.println("filename=" + filename);
					
					// make the filename unique
					String suffix = FileUtils.getFileSuffix(filename);
					String basename = FileUtils.getBasename(filename);
					filename = basename + "_" + String.valueOf(System.currentTimeMillis()) + suffix;
					System.out.println("filename=" + filename);
					
					BufferedInputStream in = null;
					BufferedOutputStream out = null;
					try {
						in = new BufferedInputStream(item.openStream(), 4096);
						localPath = new File(workDir, filename).getAbsolutePath();

						out = new BufferedOutputStream(
								new FileOutputStream(localPath), 4096);
						int bytesRead = -1;
						byte[] buf = new byte[4096];
						while ((bytesRead = in.read(buf)) != -1) {
							out.write(buf, 0, bytesRead);
						}
					} finally {
						FileUtils.close(in);
						FileUtils.close(out);
					}
				}
			}

			IUploadManagementService ums = ServiceFactory
					.getUploadManagementService(dbID);

			UploadStatusInfo usi = ums.doUploadStaging(ui, workDir
					.getAbsolutePath(), filename, experimentName, subjectID);
			
			File tarFile = new File(workDir, filename);
			if (tarFile.exists()) {
				tarFile.delete();
			}
			
			JSONObject json = usi.toJSON();

			prepJSONResponse(response, json);

			return null;
		} catch (Throwable t) {
			t.printStackTrace();
			throw new Exception(t);
		}
	}

	protected void prepJSONResponse(HttpServletResponse response, JSONObject js)
			throws IOException {
		response.setContentType("application/json");
		String jsonStr = js.toString();
		response.getOutputStream().println(jsonStr);
	}

	protected String getDBID() throws Exception {
		IAppConfigService cs = AppConfigService.getInstance();
		String dbID = cs.getParamValue("fbirn.dbid");

		if (dbID == null || dbID.trim().length() == 0) {
			throw new Exception(
					"Cannot detect data source! Possible misconfiguration!");
		}
		return dbID;
	}
}
