package clinical.web.actions;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.common.ISecurityAdminService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;
import clinical.web.exception.ValidationException;
import clinical.web.forms.UserConfigForm;
import clinical.web.services.SecurityService;

public class AccountManagementAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	private Log log = LogFactory.getLog(AccountManagementAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.am.view", "viewMain");
		map.put("button.am.admin", "changePassword");
		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewMain");
		try {
			UserInfo ui = getUserInfo(request);
			UserConfigForm configForm = (UserConfigForm) form;
			configForm.setUserName(ui.getName());

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}

	}

	public ActionForward changePassword(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			UserConfigForm configForm = (UserConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			String userName = configForm.getUserName().trim();
			String pwd = configForm.getPassword().trim();
			String pwdConfirm = configForm.getPasswordRepeat().trim();

			String dbID = ServiceFactory.getSecurityService().getDefaultDBID();

			DBConfig defDBConfig = saService.getDBConfigMap().get(dbID);

			validateFields(pwd, pwdConfirm);
			User existingWU = defDBConfig.findUser(userName);

			boolean useGSI = GenUtils.toBoolean(configForm.getUseGSI(), false);
			User webUser = new User(userName.trim(), pwd.trim(), existingWU.getUserPrivSet(), useGSI);
			webUser.setDbUser(existingWU.getDbUser());

			SecurityService ss = (SecurityService) saService;
			
			ss.editWebUser(defDBConfig, webUser);

			return mapping.findForward(Constants.PC_SUCCESS);
		} catch (Exception x) {
			log.error("editWebUser", x);
			return processExceptions(request, response, mapping, form, x);
		}

	}

	private void validateFields(String pwd, String pwdConfirm)
			throws ValidationException {
		if (pwd == null || pwd.trim().length() == 0) {
			throw new ValidationException(
					"A non empty password needs to be specified!");
		}
		if (pwdConfirm == null || pwdConfirm.trim().length() == 0
				|| !pwd.equals(pwdConfirm)) {
			throw new ValidationException(
					"Both password field and confirm password field contents must match!");
		}
	}
}
