package clinical.web.actions;

import java.io.File;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jdom.Element;

import clinical.server.vo.Dataarchive;
import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.IImageDataService;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.download.DataNode;
import clinical.web.download.FileBundleConfig;
import clinical.web.download.FileInfo;
import clinical.web.download.ProjectDownloadJob;
import clinical.web.download.ProjectImageDataBundle;
import clinical.web.exception.ValidationException;
import clinical.web.forms.ByProjectDownloadForm;
import clinical.web.helpers.EmailHelper;
import clinical.web.scheduler.JobScheduler;
import clinical.web.scheduler.JobScheduler.JobSubmissionType;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ByProjectDownloadAction.java,v 1.1.2.1 2007/09/26 22:36:51
 *          bozyurt Exp $
 */
public class ByProjectDownloadAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(ByProjectDownloadAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.pd.view", "viewPage");
		map.put("button.pd.download", "scheduleDownload");
		return map;
	}

	public ActionForward viewPage(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewPage");
		try {
			UserInfo ui = getUserInfo(request);
			ByProjectDownloadForm pdForm = (ByProjectDownloadForm) form;
			pdForm.setScheduled(false);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			IAppConfigService configService = ServiceFactory.getAppConfigService(); 			
			
			String emailHost = configService.getParamValue("email.host");
			String emailUser = configService.getParamValue("email.user");
			String emailPwd = configService.getParamValue("email.pwd");
			String emailFrom = configService.getParamValue("email.from");
			boolean canSendEmail =  GenUtils.isNotEmpty(emailUser)
					&& GenUtils.isNotEmpty(emailPwd)
					&& GenUtils.isNotEmpty(emailHost)
					&& GenUtils.isNotEmpty(emailFrom);

			canSendEmail &= GenUtils.isValidEmail(emailFrom);

			pdForm.setSupportEmail(canSendEmail);
			if (canSendEmail) {
				if (GenUtils.isValidEmail(ui.getPerceivedName())) {
					pdForm.setEmail(ui.getPerceivedName());
				}
			}

			IImageDataService ids = ServiceFactory.getImageDataService(dbID);

			Map<String, List<Dataarchive>> byProjectMap = ids
					.getArchivedDataByProject(ui);

			for (Iterator<Map.Entry<String, List<Dataarchive>>> it = byProjectMap
					.entrySet().iterator(); it.hasNext();) {
				Map.Entry<String, List<Dataarchive>> entry = it.next();
				String expName =  entry.getKey();
				List<Dataarchive> childList = entry.getValue();
				String treeId = "t_" + pdForm.nextId();
				String expDesc = null;
				if (!childList.isEmpty()) {
					expDesc = childList.iterator().next()
							.getDescription();
				}

				ProjectImageDataBundle pidb = new ProjectImageDataBundle(
						expName, treeId, expDesc);
				pdForm.addProject(pidb);
				for (Iterator<Dataarchive> it2 = childList.iterator(); it2.hasNext();) {
					Dataarchive da = it2.next();
					String dataURI = da.getDatauri();
					String description = da.getDatadescription();
					long dataSize = (da.getDatasize() != null) ? da
							.getDatasize().longValue() : 0;
					pidb.addSubjectVisitFile(dataURI, dataSize, description);
				}
			}

			return mapping.findForward(Constants.VIEW);
		} catch (Exception x) {
			log.error("viewPage", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward scheduleDownload(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> scheduleDownload");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			ByProjectDownloadForm pdForm = (ByProjectDownloadForm) form;
			String results = request.getParameter("results");
			String bundleName = pdForm.getBundleName();
			log.info("results:" + results);
			log.info("bundleName: " + bundleName);

			if (bundleName == null || bundleName.trim().length() == 0) {
				bundleName = "project_download";
			}

			
			IAppConfigService configService = ServiceFactory.getAppConfigService();

			String cacheRoot = configService.getParamValue("download.cacheroot");
			
			if (cacheRoot == null || cacheRoot.trim().length() == 0) {
				throw new ValidationException(
						"System Setup Problem: A valid cache root directory needs "
								+ "to be supplied during system setup with property download.cacheroot:! ");
			}
			String id = String.valueOf(System.currentTimeMillis());
			String description = "archive download named '" + bundleName + "'";
			File cacheDir = new File(cacheRoot, id);
			cacheDir.mkdirs();
			FileBundleConfig fbc = prepareFileBundleConfig(results, bundleName,
					cacheDir.getAbsolutePath(), pdForm.getProjects());

			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			ProjectDownloadJob job = new ProjectDownloadJob(id, ui,
					description, fbc, dbID);

			if (pdForm.isSupportEmail() && pdForm.isNotifyByEmail()
					&& GenUtils.isNotEmpty(pdForm.getEmail())
					&& GenUtils.isValidEmail(pdForm.getEmail())) {

				String emailHost = configService.getParamValue("email.host");
				String emailUser = configService.getParamValue("email.user");
				String emailPwd = configService.getParamValue("email.pwd");
				String emailFrom = configService.getParamValue("email.from");
				EmailHelper emailHelper = new EmailHelper(emailHost, emailUser,
						emailPwd, emailFrom);
				emailHelper.setToUser(pdForm.getEmail());
				job.setEmailHelper(emailHelper);
				pdForm.setWillNotify(true);
			}

			JobScheduler scheduler = JobScheduler.getInstance();
			scheduler.addJob(job, JobSubmissionType.INDIVIDUAL);
			pdForm.setScheduledJobId(id);

			pdForm.setScheduled(true);

			return mapping.findForward(Constants.SCHEDULE_DOWNLOAD);
		} catch (Exception x) {
			log.error("scheduleDownload", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public static FileBundleConfig prepareFileBundleConfig(
			String selectedItemsXML, String bundleName, String cacheDir,
			List<ProjectImageDataBundle> pidbList) throws Exception {
		Map<String, ProjectImageDataBundle> pidbMap = new HashMap<String, ProjectImageDataBundle>(
				7);
		for (ProjectImageDataBundle pidb : pidbList) {
			pidbMap.put(pidb.getExperimentName(), pidb);
		}

		FileBundleConfig fbc = new FileBundleConfig(FileBundleConfig.TARRED,
				bundleName, cacheDir);
		Element rootElem = FileUtils
				.loadXML(new StringReader(selectedItemsXML));
		List<?> itemElems = rootElem.getChildren("item");
		for (Iterator<?> it = itemElems.iterator(); it.hasNext();) {
			Element itemElem = (Element) it.next();
			String item = itemElem.getTextTrim();
			int idx = item.lastIndexOf('(');
			if (idx != -1) {
				item = item.substring(0, idx).trim();
			}
			String[] parts = item.split("\\/");
			item = parts[parts.length - 1];

			// assumption <label>/experimentname/.../<filename>
			String experimentName = parts[1];
			ProjectImageDataBundle pidb = pidbMap.get(experimentName);
			Assertion.assertNotNull(pidb);
			DataNode dn = pidb.findByPath(item);
			Assertion.assertNotNull(dn);
			FileInfo fi = (FileInfo) dn.getUserObject();
			// it is assumed that all project archive files under a project have
			// same root directory
			String srcRootDir = new File(fi.getPath()).getParent();
			fi.setSourceRootDir(srcRootDir);
			fbc.addFileInfo(fi);
		}
		return fbc;
	}
}
