package clinical.web.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAssessmentService;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.upload.AssessmentType;

public class CAManAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(CAManAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.caman.view", "viewMain");
		map.put("action.caman.create", "createAssessmentType");
		map.put("action.caman.all", "getDeletableAssessments");
		map.put("action.caman.delete", "deleteAssessment");
		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			getUserInfo(request);
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward getDeletableAssessments(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			IAssessmentService service = ServiceFactory
					.getAssessmentService(dbID);
			List<AssessmentInfo> aiList = service
					.getAssessmentsWithoutAnyData(ui);
			JSONObject respJS = new JSONObject();
			JSONArray jsarr = new JSONArray();
			respJS.put("aiList", jsarr);
			for (AssessmentInfo ai : aiList) {
				JSONObject js = new JSONObject();
				jsarr.put(js);
				js.put("id", ai.getAssessmentID());
				js.put("name", ai.getName());
			}
			response.setContentType("application/json");
			response.getOutputStream().println(respJS.toString());
		} catch (Exception x) {
			log.error("getDeletableAssessments", x);
			response.setContentType("application/json");
			JSONObject respJS = new JSONObject();
			respJS.put("error", x.getMessage());
			response.getOutputStream().println(respJS.toString());
		}
		return null;
	}

	public ActionForward deleteAssessment(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			log.info("deleteAssessment");
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			String asIdStr = request.getParameter("asId");
			int asId = GenUtils.toInt(asIdStr, -1);
			IAssessmentService service = ServiceFactory
					.getAssessmentService(dbID);

			service.deleteAssessmentType(ui, asId);
			JSONObject respJS = new JSONObject();
			response.setContentType("application/json");
			response.getOutputStream().println(respJS.toString());
		} catch (Exception x) {
			log.error("deleteAssessment", x);
			response.setContentType("application/json");
			JSONObject respJS = new JSONObject();
			respJS.put("error", x.getMessage());
			response.getOutputStream().println(respJS.toString());
		}
		return null;
	}

	public ActionForward createAssessmentType(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			String jsonStr = request.getParameter("newAT");
			System.out.println("jsonStr:" + jsonStr);
			JSONObject js = new JSONObject(jsonStr);
			AssessmentType at = AssessmentType.initializeFromJSON(js);
			IAssessmentService service = ServiceFactory
					.getAssessmentService(dbID);

			service.addAssessmentType(ui, at);
			response.setContentType("application/json");
			JSONObject respJS = new JSONObject();
			respJS.put("name", at.getName());
			response.getOutputStream().println(respJS.toString());
		} catch (Exception x) {
			log.error("createAssessmentType", x);
			response.setContentType("application/json");
			JSONObject respJS = new JSONObject();
			respJS.put("error", x.getMessage());
			response.getOutputStream().println(respJS.toString());
		}
		return null;
	}
}
