package clinical.web.actions;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.exolab.castor.xml.ValidationException;
import org.json.JSONObject;

import clinical.server.vo.Experiment;
import clinical.server.vo.JobProvenance;
import clinical.server.vo.VisitJob;
import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ICBFProcReportQueryService;
import clinical.web.IJobManagementService;
import clinical.web.ISubjectVisitManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthorizationService;
import clinical.web.common.IAuthorizationService.PrivilegeLabel;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.CBFProcessReportRec;
import clinical.web.common.vo.CBFProcessReportRecListWrapper;
import clinical.web.download.FileBundleConfig;
import clinical.web.download.Packager;
import clinical.web.download.PathWrapper;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.helpers.MultipleExperimentSelector;
import clinical.web.services.IJobProvenanceService;

/**
 * @author I. Burak Ozyurt
 * @version $Id: CBFProcessingReportQueryAction.java 717 2012-11-06 01:21:17Z bozyurt $
 */

public class CBFProcessingReportQueryAction extends BaseLookupDispatchAction {
    private Map<String, String> map = new HashMap<String, String>(5);
    private Log log = LogFactory.getLog(CBFProcessingReportQueryAction.class);
    public static final String REL_REPORT_IMAGES_PATH = "/report/";

    protected Map<String, String> getKeyMethodMap() {
        map.put("action.cprq.show", "show");
        map.put("action.cprq.query", "query");
        map.put("action.cprq.download", "download");
        return map;
    }

    public ActionForward show(ActionMapping mapping, ActionForm form,
                              HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        log.info("in show");
        AsQueryBuilderForm queryForm;
        try {
            UserInfo ui = getUserInfo(request);
            queryForm = (AsQueryBuilderForm) form;
            HttpSession session = request.getSession(false);
            String dbID = (String) session
                    .getAttribute(Constants.SESSION_DBID_KEY);
            ISubjectVisitManagement isvm = ServiceFactory
                    .getSubjectVisitManagement(dbID);
            List<Experiment> allVisibleExperiments = isvm
                    .getAllVisibleExperiments(ui);
            prepareExperimentSelector(allVisibleExperiments, queryForm);

            return mapping.findForward(Constants.SUCCESS);
        } catch (Exception x) {
            return processExceptions(request, response, mapping, form, x);
        }
    }

    public ActionForward download(ActionMapping mapping, ActionForm form,
                                  HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        try {
            log.info("download");
            UserInfo ui = getUserInfo(request);
            HttpSession session = request.getSession(false);
            String dbID = (String) session
                    .getAttribute(Constants.SESSION_DBID_KEY);

            String jobID = request.getParameter("selJobID");
            log.info("jobID:" + jobID);

            // double check if the group analysis job is visible by the
            // user
            IAuthorizationService authService = ServiceFactory
                    .getAuthorizationService();
            if (!authService.isAuthorized(ui, dbID,
                    PrivilegeLabel.CREATE_SUBJECT, null)
                    && !authService.isAuthorized(ui, dbID,
                    PrivilegeLabel.UPDATE, null)
                    && !authService.isAuthorized(ui, dbID,
                    PrivilegeLabel.ADMIN, null)
                    && !authService.isAuthorized(ui, dbID,
                    PrivilegeLabel.UPDATE, null)) {
                throw new Exception(
                        "User '"
                                + ui.getName()
                                + "' is unauthorized to download CBF processing results!");
            }

            IAppConfigService configService = ServiceFactory
                    .getAppConfigService();
            String cacheRoot = configService
                    .getParamValue("download.cacheroot");
            if (cacheRoot == null || cacheRoot.trim().length() == 0) {
                throw new ValidationException(
                        "System Setup Problem: A valid cache root directory needs to be supplied "
                                + "during system setup with property download.cacheroot:! ");
            }

            IJobProvenanceService jps = ServiceFactory
                    .getJobProvenanceService(dbID);

            JobProvenance jp = jps.findJobProvenanceByJobID(ui, jobID);
            if (jp == null) {
                return null;
            }
            IJobManagementService jms = ServiceFactory
                    .getJobManagementService(dbID);

            VisitJob vj = jms.findVisitJob(ui, jobID);
            if (vj == null) {
                return null;
            }
            IDBCache dbCache = ServiceFactory.getDBCache(dbID);
            List<Experiment> experiments = dbCache.getExperiments(ui, false);
            String expRootDir = null;
            for (Experiment exp : experiments) {
                if (exp.getUniqueid().equals(vj.getExpId())) {
                    expRootDir = exp.getBaseuri();
                    break;
                }
            }
            Assertion.assertNotNull(expRootDir);
            String derivedDir = jp.getDatauri();
            String relPath = FileUtils.getRelativePath(expRootDir, derivedDir);
            String[] parts = relPath.split("/");
            String bundleName = parts[0] + "_" + parts[1];

            File cacheDir = new File(cacheRoot, "cbf_" + jobID);
            File tarFile = new File(cacheDir, bundleName + ".tar.gz");

            if (!cacheDir.isDirectory() || !tarFile.isFile()) {
                if (!cacheDir.isDirectory()) {
                    cacheDir.mkdir();
                }
                List<File> derivedFiles = FileUtils
                        .getAllFilesUnderDir(derivedDir);
                List<PathWrapper> allFiles = new ArrayList<PathWrapper>(
                        derivedFiles.size());
                String srcRootDir = new File(expRootDir).getParentFile()
                        .getAbsolutePath();
                for (File df : derivedFiles) {
                    String relativePath = FileUtils.getRelativePath(srcRootDir,
                            df.getAbsolutePath());
                    PathWrapper pw = new PathWrapper(relativePath, srcRootDir);
                    allFiles.add(pw);
                }// final packaging
                Packager p = new Packager(cacheDir.getAbsolutePath(),
                        bundleName, FileBundleConfig.GZIPPED);
                p.includeFiles(allFiles);
                p.pack();
            }

            // now stream the tar file
            log.info("streaming file to the browser:" + tarFile);

            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename="
                    + tarFile.getName());
            // for jquery filedownload plugin
            response.setHeader("Set-Cookie", "fileDownload=true; path=/");
            // let's the browser to not cache this page
            response.setHeader("CACHE-CONTROL", "no-cache");
            response.setHeader("expires", "0");

            try {
                OutputStream os = response.getOutputStream();
                FileUtils.copyContent(tarFile.getAbsolutePath(), os);
            } finally {
                FileUtils.close(response.getOutputStream());
            }

            return null;
        } catch (Throwable t) {
            Exception x = (t instanceof Exception) ? (Exception) t
                    : new Exception(t);
            return processExceptions(request, response, mapping, form, x);
        }
    }

    public ActionForward query(ActionMapping mapping, ActionForm form,
                               HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        AsQueryBuilderForm queryForm;
        try {
            log.info("query");
            UserInfo ui = getUserInfo(request);
            String queryString = request.getParameter("queryString");
            Assertion.assertNotNull(queryString);
            log.info("queryString:" + queryString);
            HttpSession session = request.getSession(false);
            String dbID = (String) session
                    .getAttribute(Constants.SESSION_DBID_KEY);

            queryForm = (AsQueryBuilderForm) form;

            ISubjectVisitManagement isvm = ServiceFactory
                    .getSubjectVisitManagement(dbID);
            List<Experiment> allVisibleExperiments = isvm
                    .getAllVisibleExperiments(ui);

            int[] selectedExpIDs = queryForm.getReportExpSelector()
                    .getSelectedExpIDs();
            List<Experiment> filteredExpList = allVisibleExperiments;
            boolean hasAllExps = false;
            if (selectedExpIDs == null || selectedExpIDs.length == 0) {
                hasAllExps = true;
            } else {
                for (int selectedExpID : selectedExpIDs) {
                    if (selectedExpID == MultipleExperimentSelector.ALL_EXPERIMENTS) {
                        hasAllExps = true;
                        break;
                    }
                }
            }
            if (!hasAllExps) {
                Set<Integer> selectedExpIdSet = new HashSet<Integer>();
                for (int selectedExpID : selectedExpIDs) {
                    selectedExpIdSet.add(selectedExpID);
                }
                filteredExpList = new ArrayList<Experiment>(
                        selectedExpIdSet.size());
                for (Experiment exp : allVisibleExperiments) {
                    if (selectedExpIdSet.contains(exp.getUniqueid().intValue())) {
                        filteredExpList.add(exp);
                    }
                }
            }

            ICBFProcReportQueryService icrqs = ServiceFactory
                    .getCBFProcReportQueryService(dbID);

            CBFProcessReportRecListWrapper resultSet = icrqs
                    .getCBFProcessRecords(ui, filteredExpList);

            String cacheRoot = REL_REPORT_IMAGES_PATH;
            cacheRoot = session.getServletContext().getRealPath(cacheRoot);
            new File(cacheRoot).mkdirs();
            for (CBFProcessReportRec rec : resultSet.getRecords()) {
                if (rec.getCbfImagePath() != null) {
                    rec.setCbfImagePath(getCachedImgPath(cacheRoot, rec,
                            rec.getCbfImagePath()));
                }
                if (rec.getHistogramImagePath() != null) {
                    rec.setHistogramImagePath(getCachedImgPath(cacheRoot, rec,
                            rec.getHistogramImagePath()));
                }
                if (rec.getMotionImagePath() != null) {
                    rec.setMotionImagePath(getCachedImgPath(cacheRoot, rec,
                            rec.getMotionImagePath()));
                }
                if (rec.getCsfMasksImagePath() != null) {
                    rec.setCsfMasksImagePath(getCachedImgPath(cacheRoot, rec,
                            rec.getCsfMasksImagePath()));
                }
                if (rec.getCsfSlicesImagePath() != null) {
                    rec.setCsfSlicesImagePath(getCachedImgPath(cacheRoot, rec,
                            rec.getCsfSlicesImagePath()));
                }
                if (rec.getCsfMapPVImagePath() != null) {
                    rec.setCsfMapPVImagePath(getCachedImgPath(cacheRoot, rec,
                            rec.getCsfMapPVImagePath()));
                }
                if (rec.getCsfMapTop5ImagePath() != null) {
                    rec.setCsfMapTop5ImagePath(getCachedImgPath(cacheRoot, rec,
                            rec.getCsfMapTop5ImagePath()));
                }
                if (rec.getCsfRoiPVImagePath() != null) {
                    rec.setCsfRoiPVImagePath(getCachedImgPath(cacheRoot, rec,
                            rec.getCsfRoiPVImagePath()));
                }
                if (rec.getCsfRoiTop5ImagePath() != null) {
                    rec.setCsfRoiTop5ImagePath(getCachedImgPath(cacheRoot, rec,
                            rec.getCsfRoiTop5ImagePath()));
                }
            }

            JSONObject json = resultSet.toJSON();
            if (log.isDebugEnabled()) {
                log.debug("jsonStr:" + json.toString(2));
            }
            queryForm.setCbfProcRecordsJSONStr(json.toString());

            return mapping.findForward(Constants.FORWARD_RESULTS);
        } catch (Exception x) {
            return processExceptions(request, response, mapping, form, x);
        }
    }

    private String getCachedImgPath(String cacheRoot, CBFProcessReportRec rec,
                                    String srcPath) throws IOException {
        File cacheImg = prepCachedImage(cacheRoot, rec, srcPath);
        if (cacheImg != null) {
            return getBasePart(cacheImg, "report");
        } else {
            return null;
        }
    }

    private void prepareExperimentSelector(
            List<Experiment> allVisibleExperiments, AsQueryBuilderForm queryForm) {
        // create an ExperimentSelector
        MultipleExperimentSelector expSelector = new MultipleExperimentSelector(
                allVisibleExperiments);
        if (queryForm.getReportExpSelector() != null) {
            int[] selectedExpIDs = queryForm.getReportExpSelector()
                    .getSelectedExpIDs();
            expSelector.setSelectedExpIDs(selectedExpIDs);
        }
        queryForm.setReportExpSelector(expSelector);

    }

    private File prepCachedImage(String cacheRoot, CBFProcessReportRec rec,
                                 String srcImagePathStr) throws IOException {
        File srcPath = new File(srcImagePathStr);
        String basePart = getBasePart(srcPath, rec.getProjectName());
        if (basePart == null) {
            return null;
        }
        File destFile = new File(cacheRoot, basePart);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
            FileUtils.copyFile(srcPath.getAbsolutePath(),
                    destFile.getAbsolutePath());
        } else {
            if (destFile.exists()) {
                // check if the source file is newer than the
                // destination one
                if (srcPath.lastModified() > destFile.lastModified()) {
                    FileUtils.copyFile(srcPath.getAbsolutePath(),
                            destFile.getAbsolutePath());
                }

            } else {
                FileUtils.copyFile(srcPath.getAbsolutePath(),
                        destFile.getAbsolutePath());
            }
        }
        return destFile;
    }

    static String getBasePart(File fullPath, String startPart) {
        // any spaces in startPart is converted to underscores
        if (startPart.indexOf(' ') != -1) {
            startPart = startPart.replaceAll("\\s+", "_");
        }
        String s = fullPath.getAbsolutePath();
        String[] parts = s.split("/+");
        int idx = -1;
        for (int i = 0; i < parts.length; i++) {
            if (parts[i].equals(startPart)) {
                idx = i;
                break;
            }
        }
        if (idx == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder(128);
        for (int i = idx; i < parts.length; i++) {
            sb.append(parts[i]);
            if ((i + 1) < parts.length) {
                sb.append("/");
            }
        }
        return sb.toString();
    }
}
