package clinical.web.actions;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.cache.DBChange;
import clinical.cache.DBChangeSupport;
import clinical.cache.TableChange;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: CacheEventAction.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class CacheEventAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(CacheEventAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.cache.changed", "changed");
		return map;
	}

	public ActionForward changed(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> changed");
		String dbChangeJSON = request.getParameter("dbChangeJSON");
		if (dbChangeJSON == null)
			return null;
		try {
			JSONObject js = new JSONObject(dbChangeJSON);
			DBChange dbChange = DBChange.fromJSON(js);
            DBChangeSupport dbc = DBChangeSupport.getInstance();
			String siteID = dbChange.getSiteID();
			String[] tableNames = new String[ dbChange.getChanges().size()];
			int i = 0;
			for(TableChange tc : dbChange.getChanges()) {
                tableNames[i++] = tc.getTableName();
			}
			dbc.fireDBChangeEvent(siteID, tableNames);
		} catch (JSONException jse) {
             jse.printStackTrace();
		}
		return null;
	}

}
