package clinical.web.actions;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Rawdata;
import clinical.utils.Assertion;
import clinical.web.Constants;
import clinical.web.ImageHandler;
import clinical.web.ServiceFactory;
import clinical.web.common.IAuthenticationService;
import clinical.web.common.IDBPoolService;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.forms.SubjectVisitForm;
import clinical.web.image.ConversionWorker;
import clinical.web.services.SecurityService;
import clinical.web.vo.Visit;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ConversionProgressAction.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class ConversionProgressAction extends BaseAction {
	private Log log = LogFactory.getLog(ConversionProgressAction.class);

	public ConversionProgressAction() {
	}

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		Connection con = null;
		UserInfo ui = null;
		IDBPoolService pool = null;

		try {
			HttpSession session = request.getSession(false);
			if (session == null)
				return null;

			UserInfo userInfo = getUserInfo(request);
			IAuthenticationService authService = ServiceFactory
					.getAuthenticationService();

			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			// let's the browser to not cache this page
			response.setHeader("CACHE-CONTROL", "no-cache");
			response.setHeader("expires", "0");

			SubjectVisitForm svForm = (SubjectVisitForm) form;

			String siteID = svForm.getSiteID();

		
			SecurityService ss = (SecurityService) ServiceFactory.getSecurityService();
            String theDBID = ss.findDBForSiteID(siteID);
            Assertion.assertNotNull(theDBID);
            
			//		String theDBID = GenUtils.extractDBIDFromBIRNID(svForm
			//		.getSubjectID(), dbID);
            
			if (theDBID != dbID) {
				ui = authService.getDefaultUser(theDBID, userInfo);
			} else {
				ui = userInfo;
			}
			pool = ServiceFactory.getPoolService(theDBID);

			con = pool.getConnection(ui.getName());

			ImageHandler imgHandler = ServiceFactory.getImageHandlerService();

			Visit vi = (Visit) svForm.getScanVisits().get(0);
			log.debug("got visit :" + vi);

			BigDecimal scanVisitID = new BigDecimal("" + vi.getComponentID());
			BigDecimal scanExpID = new BigDecimal("" + vi.getExperimentID());

			/** @todo needs segment level granularity for raw data browsing */
			List<Rawdata> rawDatas = imgHandler.getRawDataForSubject(dbID, con, svForm
					.getSubjectID(), scanVisitID, scanExpID, null);
			if (rawDatas.size() == 1) {
				Rawdata rd = (Rawdata) rawDatas.get(0);
			
				String cacheRoot = (String) session.getServletContext()
						.getAttribute(Constants.CACHE_ROOT_KEY);
				cacheRoot = session.getServletContext().getRealPath(cacheRoot);
				log.debug("got cacheRoot:" + cacheRoot);

				// String tarFile =
				// imgHandler.retrieveMRISeriesForSubject(cacheRoot,
				// rd.getDatauri(), appProps);
				// log.debug("got tarFile:"+ tarFile);

				ConversionWorker worker = (ConversionWorker) session
						.getAttribute(Constants.MRICONVERT_PROGRESS_TASK_KEY);

				if (worker != null && worker.isFinished()) {
					session
							.removeAttribute(Constants.MRICONVERT_PROGRESS_TASK_KEY);
				}
				worker = new ConversionWorker(svForm.getSubjectID(), cacheRoot,
						rd.getDatauri());
				session.setAttribute(Constants.MRICONVERT_PROGRESS_TASK_KEY,
						worker);
				Thread thread = new Thread(worker);
				thread.setDaemon(true);
				thread.setPriority(Thread.NORM_PRIORITY - 1);
				thread.start();
				return mapping.findForward(Constants.SUCCESS);
			} else {
				throw new BaseException(
						"Cannot handle multiple scan series per subject yet!");
			}

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		} finally {
			if (pool != null)
				pool.releaseConnection(ui.getName(), con);
		}

	}

}
