package clinical.web.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.ConfWebuser;
import clinical.utils.GenUtils;
import clinical.utils.ValidationUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ServiceFactory;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;
import clinical.web.exception.BaseException;
import clinical.web.exception.ValidationException;
import clinical.web.forms.ForgotLoginInfoForm;
import clinical.web.helpers.EmailHelper;
import clinical.web.services.SecurityService;

public class ForgotLoginInfoAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	private Log log = LogFactory.getLog(ForgotLoginInfoAction.class);
	private final static String EMAIL_SUBJECT = "Account information for CBFDAP";

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.fli.view", "viewMain");
		map.put("action.fli.retrieve", "sendLoginInfo");
		return map;
	}

	public ActionForward viewMain(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> viewMain");
		try {
			return mapping.findForward(Constants.INPUT);
		} catch (Exception x) {
			log.error("viewMain", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward sendLoginInfo(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> sendLoginInfo");
		try {
			log.info("handling forgotten login info");
			ForgotLoginInfoForm fliForm = (ForgotLoginInfoForm) form;
			if (!canSendEmail()) {
				throw new BaseException(
						"The system is not setup to send emails! Please contact the webmaster!");
			}

			String email = fliForm.getEmail();

			if (email == null || email.length() == 0) {
				throw new ValidationException(
						"The email used to register the user is required!");
			}
			ValidationUtils.validEmail(null, email);

			applyIncludeCheckBoxes(fliForm, request);
			if (!fliForm.isIncludePwd() && !fliForm.isIncludeUsername()) {
				throw new ValidationException(
						"No login info request is specified!");
			}

			SecurityService ss = (SecurityService) ServiceFactory
					.getSecurityService();
			List<ConfWebuser> matchingUsers = ss.findByEmail(email);
			if (matchingUsers == null || matchingUsers.isEmpty()) {
				throw new ValidationException(
						"The email used to register the user is required to retrieve login information!");
			}
			ConfWebuser theUser = null;
			for (ConfWebuser wu : matchingUsers) {
				if (!wu.getName().equals(Constants.ADMIN_USER)) {
					theUser = wu;
					break;
				}
			}
			// admin user is not allowed
			if (theUser == null) {
				throw new ValidationException(
						"The email used to register the user is required to retrieve login information!");
			}

			String templateDir = super.servlet.getServletContext().getRealPath(
					Constants.TEMPLATE_DIR);
			String pwd = null;
			String username = null;
			if (fliForm.isIncludePwd()) {
				// reset password
				pwd = GenUtils.generatePassword(8);

				String dbID = ServiceFactory.getSecurityService()
						.getDefaultDBID();
				DBConfig defDBConfig = ss.getDBConfigMap().get(dbID);
				User existingWU = defDBConfig.findUser(theUser.getName());

				User webUser = new User(theUser.getName(), pwd.trim(),
						existingWU.getUserPrivSet(), false);
				webUser.setDbUser(existingWU.getDbUser());
				ss.editWebUser(defDBConfig, webUser);
			}
			if (fliForm.isIncludeUsername()) {
				username = theUser.getName();
			}
			handleEmail(templateDir, email, username, pwd);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("sendLoginInfo", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected void applyIncludeCheckBoxes(ForgotLoginInfoForm fliForm,
			HttpServletRequest request) {
		String value = request.getParameter("pwd");
		if (value != null && value.equals("on")) {
			fliForm.setIncludePwd(true);
		} else {
			fliForm.setIncludePwd(false);
		}
		value = request.getParameter("username");
		if (value != null && value.equals("on")) {
			fliForm.setIncludeUsername(true);
		} else {
			fliForm.setIncludeUsername(false);
		}
	}

	protected boolean canSendEmail() throws BaseException {
		IAppConfigService configService = ServiceFactory.getAppConfigService();

		String emailHost = configService.getParamValue("email.host");
		// String emailUser = configService.getParamValue("email.user");
		String emailFrom = configService.getParamValue("email.from");
		boolean canSendEmail = GenUtils.hasEnoughInfoForEmail(emailHost, emailFrom);
	
		canSendEmail &= GenUtils.isValidEmail(emailFrom);
		return canSendEmail;
	}

	protected boolean handleEmail(String templateDir, String toEmail,
			String userName, String password) throws Exception {
		IAppConfigService configService = ServiceFactory.getAppConfigService();

		String emailHost = configService.getParamValue("email.host");
		String emailUser = configService.getParamValue("email.user");
		String emailPwd = configService.getParamValue("email.pwd");
		String emailFrom = configService.getParamValue("email.from");
		boolean canSendEmail = GenUtils.hasEnoughInfoForEmail(emailHost, emailFrom);
		

		if (canSendEmail) {
			EmailHelper helper = new EmailHelper(emailHost, emailUser,
					emailPwd, emailFrom);
			Map<String, String> paramMap = new HashMap<String, String>();
			paramMap.put("email", toEmail);
			if (userName != null) {
				paramMap.put("username", userName);
			}
			if (password != null) {
				paramMap.put("pwd", password);
			}

			try {
				helper.sendEmail(toEmail, EMAIL_SUBJECT, paramMap, templateDir,
						"forgot_login.vm", false);
			} catch (Throwable t) {
				log.error("sendEmail", t);
			}
		}
		return canSendEmail;
	}

}
