package clinical.web.actions;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.cache.CacheUtils;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.DBUtils;
import clinical.web.ServiceFactory;
import clinical.web.common.ISecurityAdminService;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.User;
import clinical.web.exception.ValidationException;
import clinical.web.forms.UserConfigForm;
import clinical.web.helpers.security.AuthorizationHelper;
import clinical.web.helpers.security.UserPrivilegeSet;
import clinical.web.services.SecurityService;

/**
 * @author I. Burak Ozyurt
 * @version $Id: UserConfigAction.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class UserConfigAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(11);
	private Log log = LogFactory.getLog(UserAndDBConfigAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.userconf.add.webuser", "addWebUser");
		map.put("button.userconf.add.dbuser", "addDBUser");
		map.put("button.userconf.edit.webuser", "editWebUser");
		map.put("button.userconf.edit.dbuser", "editDBUser");

		map.put("button.userconf.remove.webuser", "removeWebUser");
		map.put("button.userconf.remove.dbuser", "removeDBUser");
		map.put("button.userconf.check.connection", "checkDBUserConnection");

		return map;
	}

	public ActionForward addWebUser(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addWebUser");
		try {
			getUserInfo(request);
			UserConfigForm configForm = (UserConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			String userName = configForm.getUserName();
			String pwd = configForm.getPassword();
			String pwdConfirm = configForm.getPasswordRepeat();
			String dbUserName = configForm.getDbUserSelector()
					.getSelectedDBUserName();
			DBConfig dbConfig = configForm.getDbConfig();
			User dbUser = dbConfig.findDBUser(dbUserName);
			validateFields(userName, pwd, pwdConfirm);

			setUseGSI(request, configForm);
			boolean useGSI = GenUtils.toBoolean(configForm.getUseGSI(), false);

			AuthorizationHelper helper = new AuthorizationHelper(dbConfig.getId());
			//UserPrivilegeSet ups = helper.prepareUserPrivileges(userName.trim(),
			//		Constants.ADMIN_USER);
			UserPrivilegeSet ups = new UserPrivilegeSet(userName.trim());
			User webUser = new User(userName.trim(), pwd.trim(), ups, useGSI);
			webUser.setDbUser(dbUser);

			SecurityService ss = (SecurityService) saService;
			ss.addWebUser(dbConfig, webUser);
			ups = helper.prepareUserPrivileges(userName.trim(),
							Constants.ADMIN_USER);
			webUser.setUserPrivSet(ups);
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("addWebUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward editWebUser(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> editWebUser");
		try {
			getUserInfo(request);
			UserConfigForm configForm = (UserConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			String userName = configForm.getUserName();
			String pwd = configForm.getPassword();
			String pwdConfirm = configForm.getPasswordRepeat();
			String dbUserName = configForm.getDbUserSelector()
					.getSelectedDBUserName();
			DBConfig dbConfig = configForm.getDbConfig();
			User dbUser = dbConfig.findDBUser(dbUserName);

			validateFields(pwd, pwdConfirm);
			setUseGSI(request, configForm);
			boolean useGSI = GenUtils.toBoolean(configForm.getUseGSI(), false);
			AuthorizationHelper helper = new AuthorizationHelper(dbConfig.getId());
			UserPrivilegeSet ups = helper.prepareUserPrivileges(userName.trim(),
					Constants.ADMIN_USER);
			User webUser = new User(userName.trim(), pwd.trim(), ups, useGSI);
			webUser.setDbUser(dbUser);

			SecurityService ss = (SecurityService) saService;
			ss.editWebUser(dbConfig, webUser);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("editWebUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected void setUseGSI(HttpServletRequest request,
			UserConfigForm configForm) {
		String value = request.getParameter("useGSI");
		if (value == null)
			configForm.setUseGSI("false");
		else
			configForm.setUseGSI("true");
	}

	public ActionForward removeWebUser(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> removeWebUser");
		try {
			getUserInfo(request);
			UserConfigForm configForm = (UserConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			String userName = configForm.getUserName();
			DBConfig dbConfig = configForm.getDbConfig();
			Assertion.assertNotNull(dbConfig);
			if (userName == null || userName.trim().length() == 0) {
				throw new ValidationException("No web user name is specified!");
			}

			SecurityService ss = (SecurityService) saService;
			ss.removeWebUser(dbConfig, userName);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("removeWebUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward addDBUser(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addDBUser");
		try {
			getUserInfo(request);

			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			UserConfigForm configForm = (UserConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			DBConfig dbConfig = configForm.getDbConfig();
			String userName = configForm.getDbUserName();
			String pwd = configForm.getPassword();
			String pwdConfirm = configForm.getPasswordRepeat();
			validateFields(userName, pwd, pwdConfirm);
			User dbUser = new User(userName.trim(), pwd.trim(), null);
			SecurityService ss = (SecurityService) saService;
			ss.addDbUser(dbConfig, dbUser);
			// make sure that dbID2SiteIDMap
			dbID2SiteIDMap.put(dbConfig.getId(), dbConfig.getSiteID());
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("addDBUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward removeDBUser(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> removeDBUser");
		try {
			getUserInfo(request);
			UserConfigForm configForm = (UserConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			String dbUserName = configForm.getDbUserName();
			DBConfig dbConfig = configForm.getDbConfig();
			Assertion.assertNotNull(dbConfig);
			if (dbUserName == null || dbUserName.trim().length() == 0) {
				throw new ValidationException("No database user name is specified!");
			}

			SecurityService ss = (SecurityService) saService;
			ss.removeDbUser(dbConfig, dbUserName);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("removeDBUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward editDBUser(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> editDBUser");
		try {
			getUserInfo(request);
			UserConfigForm configForm = (UserConfigForm) form;
			ISecurityAdminService saService = ServiceFactory
					.getSecurityAdminService();
			DBConfig dbConfig = configForm.getDbConfig();
			String userName = configForm.getDbUserName();
			String pwd = configForm.getPassword();
			String pwdConfirm = configForm.getPasswordRepeat();

			validateFields(pwd, pwdConfirm);

			User dbUser = new User(userName.trim(), pwd.trim(), null);
			SecurityService ss = (SecurityService) saService;
			ss.editDBUser(dbConfig, dbUser);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("addDBUser", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward checkDBUserConnection(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> checkDBUserConnection");
		try {
			getUserInfo(request);
			UserConfigForm configForm = (UserConfigForm) form;
			DBConfig dbConfig = configForm.getDbConfig();
			String userName = configForm.getDbUserName();
			String pwd = configForm.getPassword();
			String pwdConfirm = configForm.getPasswordRepeat();
			validateFields(userName, pwd, pwdConfirm);

			Connection con = null;
			try {
				Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
				Class.forName("org.postgresql.Driver").newInstance();

				con = DriverManager.getConnection(dbConfig.getDbURL(), userName,
						pwd);

				configForm.setTestResult("Connection Test was successful!");
				System.out.println("test was successful!");
				System.out.println(configForm.getTestResult());
			} catch (SQLException se) {
				se.printStackTrace();
				throw new ValidationException("Failed to connect to the database '"
						+ dbConfig.getId() + "'using username '" + userName
						+ "'\n and URL:" + dbConfig.getDbURL());
			} finally {
				DBUtils.close(con);
			}

			return mapping.findForward(Constants.CC_SUCCESS);
		} catch (Exception x) {
			log.error("checkDBUserConnection", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	private void validateFields(String userName, String pwd, String pwdConfirm)
			throws ValidationException {
		if (userName == null || userName.trim().length() == 0) {
			throw new ValidationException(
					"A non  empty user name needs to be specified!");
		}
		validateFields(pwd, pwdConfirm);
	}

	private void validateFields(String pwd, String pwdConfirm)
			throws ValidationException {
		if (pwd == null || pwd.trim().length() == 0) {
			throw new ValidationException(
					"A non empty password needs to be specified!");
		}
		if (pwdConfirm == null || pwdConfirm.trim().length() == 0
				|| !pwd.equals(pwdConfirm)) {
			throw new ValidationException(
					"Both password field and confirm password field contents must match!");
		}
	}

}
