package clinical.web.common;

import java.util.List;
import java.util.Map;

import clinical.web.common.security.DBConfig;
import clinical.web.common.security.Privilege;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ISecurityAdminService.java,v 1.2 2005/01/25 00:58:07 bozyurt
 *          Exp $
 */
public interface ISecurityAdminService {

	public void updateUserPoolForDatabase(DBConfig dbConfig)
			throws SecurityException;

	/**
	 * do not alter the returned hash table directly!! original is shared among
	 * multiple simultaneous users, possibly connecting to different HID
	 * database instances. Use as read only!
	 *
	 * @return
	 */
	public Map<String, DBConfig> getDBConfigMap();

	public List<Privilege> getPrivileges();

}