package clinical.web.common.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;


/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SearchPredicateList.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class SearchPredicateList {
	protected List<SearchPredicateInfo> spList;
	public final static int NONE = 1;
	public final static int AND = 1;
	public final static int OR = 2;

	public SearchPredicateList() {
		spList = new ArrayList<SearchPredicateInfo>(2);
	}

	/**
	 * Adds a search predicate to the combined list of search predicates.
	 * 
	 * @param sp
	 *            search predicate object containing a value object property
	 *            name, a corresponding value and a relational operator
	 * @param logicalOp
	 *            a logical operator used to combine the search predicates. It
	 *            can take one of the values
	 *            <code>SearchPredicateList.AND</code>,
	 *            <code>SearchPredicateList.OR</code> or
	 *            <code>SearchPredicateList.NONE</code>
	 */
	public void addSearchPredicate(SearchPredicate sp, int logicalOp) {
		SearchPredicateInfo spi = null;
		if (spList.isEmpty()) {
			spi = new SearchPredicateInfo(sp, null, NONE);
		} else {
			ListIterator<SearchPredicateInfo> it = spList.listIterator(spList.size());
			if (it.hasPrevious()) {
				SearchPredicateInfo prevSpi = it.previous();
				prevSpi.setLogicOp(logicalOp);
				spi = new SearchPredicateInfo(sp, prevSpi, NONE);
			}
		}
		spList.add(spi);
	}

	/**
	 * 
	 * @param sp
	 * @param prevSp
	 * @param logicalOp
	 * @throws java.lang.Exception
	 */
	public void addSearchPredicate(SearchPredicate sp, SearchPredicate prevSp,
			int logicalOp) throws Exception {

		for (ListIterator<SearchPredicateInfo> iter = spList.listIterator(); iter
				.hasNext();) {
			SearchPredicateInfo prevSpi = iter.next();
			if (prevSpi.getSearchPredicate().equals(prevSp)) {
				prevSpi.setLogicOp(logicalOp);
				SearchPredicateInfo spi = new SearchPredicateInfo(sp, prevSpi,
						NONE);
				iter.add(spi);
				return;
			}
		}
		throw new Exception("No previous search predicate " + prevSp.toString());
	}

	public Iterator<SearchPredicateInfo> iterator() {
		return spList.iterator();
	}

	public static class SearchPredicateInfo {
		SearchPredicate searchPredicate;
		SearchPredicateInfo previous;
		int logicOp; // for the previous SearchPredicate

		public SearchPredicateInfo(SearchPredicate sp,
				SearchPredicateInfo prev, int logicOp) {
			this.searchPredicate = sp;
			this.previous = prev;
			this.logicOp = logicOp;
		}

		// ---------------------- setters --------------
		public void setSearchPredicate(SearchPredicate newSearchPredicate) {
			this.searchPredicate = newSearchPredicate;
		}

		public void setPrevious(SearchPredicateInfo newPrevious) {
			this.previous = newPrevious;
		}

		public void setLogicOp(int newLogicOp) {
			this.logicOp = newLogicOp;
		}

		// ---------------------- getters --------------
		public SearchPredicate getSearchPredicate() {
			return this.searchPredicate;
		}

		public SearchPredicateInfo getPrevious() {
			return this.previous;
		}

		public int getLogicOp() {
			return this.logicOp;
		}

	}

}
