package clinical.web.common.vo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.CBFBIRNConstants;
import clinical.web.common.vo.CBFProcessReportRec.Param;
import clinical.web.common.vo.CBFProcessReportRec.ParamType;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class CBFProcessReportRecListWrapper {
	private List<CBFProcessReportRec> records;
	private List<Param> defaultProvenanceParams = new ArrayList<Param>(10);

	public CBFProcessReportRecListWrapper(List<CBFProcessReportRec> records) {
		this.records = records;
		defaultProvenanceParams
				.add(new Param("automated", "no", ParamType.BOOL));
		defaultProvenanceParams.add(new Param("pvc", "no", ParamType.BOOL));
		defaultProvenanceParams
				.add(new Param("fieldmap", "no", ParamType.BOOL));
		defaultProvenanceParams.add(new Param("registration", "no",
				ParamType.BOOL));
		defaultProvenanceParams.add(new Param("sense", "no", ParamType.BOOL));
		defaultProvenanceParams.add(new Param("gmThresh", "0.9",
				ParamType.NUMBER));
		defaultProvenanceParams.add(new Param("skullStripping", "yes",
				ParamType.BOOL));
		defaultProvenanceParams.add(new Param("alignment", "3. method",
				ParamType.STRING));
		defaultProvenanceParams.add(new Param("csfMethod", "Automatic",
				ParamType.STRING));
		defaultProvenanceParams.add(new Param("ltMethod", "no", ParamType.BOOL));
		defaultProvenanceParams.add(new Param("smoothingParam", "0.0",
				ParamType.NUMBER));
		defaultProvenanceParams.add(new Param(CBFBIRNConstants.KEY_FABBER, "no",
				ParamType.BOOL));
		
	}

	public List<CBFProcessReportRec> getRecords() {
		return records;
	}

	public List<Param> getDefaultProvenanceParams() {
		return defaultProvenanceParams;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		JSONArray recArr = new JSONArray();
		js.put("records", recArr);
		for (CBFProcessReportRec record : records) {
			recArr.put(record.toJSON());
		}
		JSONArray defArr = new JSONArray();
		js.put("defaults", defArr);
		for (Param param : defaultProvenanceParams) {
			defArr.put(param.toJSON());
		}
		return js;
	}

	/**
	 * populates provenance parameters for runs other than the current run for
	 * each record if there are multiple runs for the image data visit.
	 */
	public void populateOthers() {
		Map<String, List<CBFProcessReportRec>> map = new HashMap<String, List<CBFProcessReportRec>>();
		for (CBFProcessReportRec rec : records) {
			String key = rec.getKey();
			List<CBFProcessReportRec> list = map.get(key);
			if (list == null) {
				list = new ArrayList<CBFProcessReportRec>(1);
				map.put(key, list);
			}
			list.add(rec);
		}
		Comparator<CBFProcessReportRec> comp = new Comparator<CBFProcessReportRec>() {
			@Override
			public int compare(CBFProcessReportRec o1, CBFProcessReportRec o2) {
				return o1.getOrder() - o2.getOrder();
			}
		};
		// ascending run order
		for (List<CBFProcessReportRec> list : map.values()) {
			if (list.size() > 1) {
				Collections.sort(list, comp);
				for (CBFProcessReportRec rec : list) {
					prepOthers(rec, list);
				}
			}
		}
	}

	private void prepOthers(CBFProcessReportRec current,
			List<CBFProcessReportRec> list) {
		for (CBFProcessReportRec rec : list) {
			if (rec == current) {
				continue;
			}
			int order = rec.getOrder();
			String runKey = String.valueOf(order);
			if (rec.getProvenanceParams() != null) {
				for (Param p : rec.getProvenanceParams()) {
					current.putParam(runKey, p);
				}
			}

		}
	}

}
