package clinical.web.common.vo;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import clinical.utils.GenUtils;
import clinical.web.helpers.HeaderInfo;
import clinical.web.helpers.MultiValuedScoreGroupLayout;
import clinical.web.helpers.ScoreValueSummaryHeader;
import clinical.web.helpers.ScoreValueSummary.ScoreValueIdxInfo;

/**
 * Represents the query result for a particular segment of a visit and an
 * experiment to be displayed on a single row in the query results page
 *
 * @author I. Burak Ozyurt
 * @version $Id: VisitSegmentScoreValues.java,v 1.8 2007/04/12 17:09:44 bozyurt
 *          Exp $
 */
public class VisitSegmentScoreValues implements java.io.Serializable {
	private static final long serialVersionUID = 424150654616763282L;
	private int visitID;
	private int segmentID;
	private int experimentID;
	private String siteID;
	private int hcode = -1;
	private List<Object> values;
	private List<List<Object>> valueLines;
	/** holds layout objects for multi-valued scores */
	private Map<String, MultiValuedScoreGroupLayout> mvScoreGroupLayouts = new LinkedHashMap<String, MultiValuedScoreGroupLayout>(
			3);
	private String timeStamp;
	private int studyID = -1;
	private String studyName;
	private String visitDownloadURL;
	private List<ScoreValueIdxInfo> svIdxInfoList;

	public VisitSegmentScoreValues(int visitID, int segmentID,
			int experimentID, String siteID, int valuesSize) {
		this(visitID, segmentID, experimentID, siteID, valuesSize, -1, null);
	}

	public VisitSegmentScoreValues(int visitID, int segmentID,
			int experimentID, String siteID, int valuesSize, int studyID,
			String studyName) {
		this.visitID = visitID;
		this.segmentID = segmentID;
		this.experimentID = experimentID;
		this.siteID = siteID;
		this.studyID = studyID;
		this.studyName = studyName;
		values = new ArrayList<Object>(valuesSize);
		for (int i = 0; i < valuesSize; i++) {
			values.add(i, "");
		}
		// create and cache the hash key
		StringBuffer buf = new StringBuffer();
		buf.append(visitID).append('_').append(segmentID).append('_').append(
				experimentID);
		hcode = buf.toString().hashCode();
	}

	public void addValue(Object value) {
		values.add(value);
	}

	public void addValue(int idx, Object value) {
		values.set(idx, value);
	}

	public List<Object> getUnarrangedValues() {
		return values;
	}

	public List<Object> getValues() {
		NumberFormat df = DecimalFormat.getInstance();
		df.setMaximumFractionDigits(2);
		List<Object> tvl = new ArrayList<Object>(values.size());
		for (ScoreValueIdxInfo svIdxInfo : svIdxInfoList) {
			Object value = values.get(svIdxInfo.getSvIdx());
			if (value instanceof String) {
				String valueStr = (String) value;
				if (GenUtils.isDecimalNumber(valueStr)) {
					value = df.format(GenUtils.toNumber(valueStr));
				}
			} else if (value instanceof Number) {
				value = df.format((Number) value);
			}

			tvl.add(value);
		}
		return tvl;
	}

	public List<List<Object>> getValueLines() {
		return valueLines;
	}

	public void setValueLines(List<List<Object>> newValueLines) {
		this.valueLines = newValueLines;
	}

	public static List<List<Object>> getValueLines(List<Object> values, List<List<HeaderInfo>> headerLines) {
		List<List<Object>> valueLines = new ArrayList<List<Object>>(1);
		for (Iterator<List<HeaderInfo>> iter = headerLines.iterator(); iter.hasNext();) {
			List<HeaderInfo> headerLine = iter.next();
			int noItems = ScoreValueSummaryHeader.countHeaderItems(headerLine);
			List<Object> valueLine = new ArrayList<Object>(noItems);

			for (Iterator<HeaderInfo> it = headerLine.iterator(); it.hasNext();) {
				HeaderInfo hi = it.next();
				if (hi.getHeaderType() != HeaderInfo.ASSESSMENT) {
					continue;
				}

				for (String subHeader : hi.getSubHeaders()) {
					// sub header is the score name !!
					int shidx = hi.getSubHeaderIndex(subHeader);
					valueLine.add(values.get(shidx));
				}// it2
			}// it
			valueLines.add(valueLine);
		}
		return valueLines;
	}

	public void addMultiValuedScoreLayoutGroup(MultiValuedScoreGroupLayout mvsgl) {
		mvScoreGroupLayouts.put(mvsgl.getAssessmentName(), mvsgl);
	}

	public MultiValuedScoreGroupLayout getMultiValuedScoreGroupLayout(
			String asName) {
		return mvScoreGroupLayouts.get(asName);
	}

	public Collection<MultiValuedScoreGroupLayout> getMultiValuedScoreGroupLayouts() {
		return this.mvScoreGroupLayouts.values();
	}

	public int getVisitID() {
		return this.visitID;
	}

	public int getSegmentID() {
		return this.segmentID;
	}

	public int getExperimentID() {
		return this.experimentID;
	}

	public String getSiteID() {
		return this.siteID;
	}

	public String getTimeStamp() {
		return this.timeStamp;
	}

	public void setTimeStamp(String newTimeStamp) {
		this.timeStamp = newTimeStamp;
	}

	public int getStudyID() {
		return this.studyID;
	}

	public String getStudyName() {
		return this.studyName;
	}

	public void setStudyID(int newStudyID) {
		this.studyID = newStudyID;
	}

	public void setStudyName(String newName) {
		this.studyName = newName;
	}

	public void setVisitDownloadURL(String newVisitDownloadURL) {
		this.visitDownloadURL = newVisitDownloadURL;
	}

	public String getVisitDownloadURL() {
		return this.visitDownloadURL;
	}

	public int hashCode() {
		return hcode;
	}

	public boolean equals(Object other) {
		if (other == null || !(other instanceof VisitSegmentScoreValues))
			return false;
		VisitSegmentScoreValues ov = (VisitSegmentScoreValues) other;
		return (visitID == ov.visitID && segmentID == ov.segmentID && experimentID == ov.experimentID);
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(152);
		buf.append("VisitSegmentScoreValues::[");
		buf.append("visitID=").append(visitID);
		buf.append(", segmentID=").append(segmentID);
		buf.append(", experimentID=").append(experimentID);
		buf.append(", siteID=").append(siteID);
		buf.append("\n");
		for (Iterator<Object> iter = values.iterator(); iter.hasNext();) {
			Object item = iter.next();
			buf.append(item).append(',');

		}
		buf.append(']');
		return buf.toString();
	}

	public void setSvIdxInfoList(List<ScoreValueIdxInfo> svIdxInfoList) {
		this.svIdxInfoList = svIdxInfoList;
	}

}
