package clinical.web.download;

import java.io.Serializable;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ObjectInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class ObjectInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	protected String label;
	protected String id;
	protected String type;

	public ObjectInfo() {
	}

	public ObjectInfo(String id, String label, String type) {
		super();
		this.id = id;
		this.label = label;
		this.type = type;
	}

	public String getId() {
		return id;
	}

	public String getLabel() {
		return label;
	}

	public String getType() {
		return type;
	}

	public String toString() {
		return label;
	}

	public int hashCode() {
		int result = 14;
		result = 29 * result + id.hashCode();
		result = 29 * result + type.hashCode();
		return result;

	}

	public boolean equals(Object other) {
		if (other == null || !(other instanceof ObjectInfo)) {
			return false;
		}
		return id.equals(((ObjectInfo) other).id)
				&& type.equals(((ObjectInfo) other).type);
	}

	public void setId(String id) {
		this.id = id;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public void setType(String type) {
		this.type = type;
	}
}
