package clinical.web.forms;

import java.util.ArrayList;
import java.util.List;

import org.apache.struts.action.ActionForm;

import clinical.web.download.ProjectImageDataBundle;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ByProjectDownloadForm.java,v 1.2 2007/10/10 01:10:40 bozyurt
 *          Exp $
 */
public class ByProjectDownloadForm extends ActionForm {
	protected List<ProjectImageDataBundle> projects = new ArrayList<ProjectImageDataBundle>(
			6);
	protected int idCounter = 0;
	protected String bundleName;
	protected String scheduledJobId;
	protected boolean scheduled = false;
	protected boolean supportEmail = false;
	protected String email;
	protected boolean notifyByEmail = false;
	protected boolean willNotify = false;

	private static final long serialVersionUID = 1L;

	public void addProject(ProjectImageDataBundle pidb) {
		if (!projects.contains(pidb)) {
			projects.add(pidb);
		}
	}

	public List<ProjectImageDataBundle> getProjects() {
		return projects;
	}

	public int nextId() {
		return ++idCounter;
	}

	public String getBundleName() {
		return bundleName;
	}

	public void setBundleName(String bundleName) {
		this.bundleName = bundleName;
	}

	public String getScheduledJobId() {
		return scheduledJobId;
	}

	public void setScheduledJobId(String scheduledJobId) {
		this.scheduledJobId = scheduledJobId;
	}

	public boolean isScheduled() {
		return scheduled;
	}

	public void setScheduled(boolean scheduled) {
		this.scheduled = scheduled;
	}

	public boolean isSupportEmail() {
		return supportEmail;
	}

	public String getEmail() {
		return email;
	}

	public boolean isNotifyByEmail() {
		return notifyByEmail;
	}

	public void setSupportEmail(boolean supportEmail) {
		this.supportEmail = supportEmail;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public void setNotifyByEmail(boolean notifyByEmail) {
		this.notifyByEmail = notifyByEmail;
	}

	public boolean isWillNotify() {
		return willNotify;
	}

	public void setWillNotify(boolean willNotify) {
		this.willNotify = willNotify;
	}

}
