package clinical.web.forms;

import java.util.List;

import org.apache.struts.action.ActionForm;
import org.apache.struts.upload.FormFile;
import org.json.JSONArray;

import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.common.vo.CBFProcessReportRec;
import clinical.web.common.vo.CBFProcessReportRecListWrapper;
import clinical.web.vo.CBFQueryInfo;
import clinical.web.vo.CBFROIJobAssociation;
import clinical.web.vo.FactorRepeatedMeasureInfo;

public class PostprocessCBFJobForm extends ActionForm {
	private static final long serialVersionUID = 1L;
	/** true only if there are visits with data to process */
	private boolean hasData = false;
	private List<AssessmentSelectionInfo> asiList;
	private CBFQueryInfo queryInfo;
	private String queryMetaDataJSON;
	private String jobListJSON;
	private CBFProcessReportRecListWrapper wrapper;
	private String queryInfoJSON;
	private FormFile tarball;
	private String jobROIAssocJSON;
	private List<CBFProcessReportRec> selectedCbfRecList;
	private List<CBFROIJobAssociation> roiJobAssocList;
	private List<CBFROIJobAssociation> finalRoiJobAssocList;
	private String userJobRoiAssocJSON;
	private String submittedJobId;
	private String[] selectedJobsItems;
	private FactorSelectionInfo factorSelectionInfo;
	private List<FactorRepeatedMeasureInfo> frmiList;
	private String jobType;
	private WizardPageState curPage = WizardPageState.NONE;
	/** optional user provided name/short description for the group analysis */
	private String gaName;
	/** only for standard space analysis */
	private boolean doQWarp = false;

	public static enum WizardPageState {
		NONE, VIEW, COLLECT_FACTOR, ASSOCIATE, COLLECT_NS_FACTOR, SUBMIT
	}

	public void clearState() {
		hasData = false;
		wrapper = null;
		asiList = null;
		jobListJSON = null;
		queryInfoJSON = null;
		jobROIAssocJSON = null;
		selectedCbfRecList = null;
		roiJobAssocList = null;
		finalRoiJobAssocList = null;
		userJobRoiAssocJSON = null;
		selectedJobsItems = null;
		factorSelectionInfo = null;
		jobType = null;
		frmiList = null;
		gaName = null;
		doQWarp = false;
	}

	public boolean isHasData() {
		return hasData;
	}

	public void setHasData(boolean hasData) {
		this.hasData = hasData;
	}

	public List<AssessmentSelectionInfo> getAsiList() {
		return asiList;
	}

	public void setAsiList(List<AssessmentSelectionInfo> asiList) {
		this.asiList = asiList;
	}

	public CBFQueryInfo getQueryInfo() {
		return queryInfo;
	}

	public void setQueryInfo(CBFQueryInfo queryInfo) {
		this.queryInfo = queryInfo;
	}

	public String getQueryMetaDataJSON() {
		return queryMetaDataJSON;
	}

	public void setQueryMetaDataJSON(String queryMetaDataJSON) {
		this.queryMetaDataJSON = queryMetaDataJSON;
	}

	public String getJobListJSON() {
		return jobListJSON;
	}

	public void setJobListJSON(String jobListJSON) {
		this.jobListJSON = jobListJSON;
	}

	public CBFProcessReportRecListWrapper getWrapper() {
		return wrapper;
	}

	public void setWrapper(CBFProcessReportRecListWrapper wrapper) {
		this.wrapper = wrapper;
	}

	public String getQueryInfoJSON() {
		return queryInfoJSON;
	}

	public void setQueryInfoJSON(String queryInfoJSON) {
		this.queryInfoJSON = queryInfoJSON;
	}

	public FormFile getTarball() {
		return tarball;
	}

	public void setTarball(FormFile tarball) {
		this.tarball = tarball;
	}

	public List<CBFProcessReportRec> getSelectedCbfRecList() {
		return selectedCbfRecList;
	}

	public void setSelectedCbfRecList(
			List<CBFProcessReportRec> selectedCbfRecList) {
		this.selectedCbfRecList = selectedCbfRecList;
	}

	public List<CBFROIJobAssociation> getRoiJobAssocList() {
		return roiJobAssocList;
	}

	public void setRoiJobAssocList(List<CBFROIJobAssociation> roiJobAssocList) {
		this.roiJobAssocList = roiJobAssocList;
	}

	public String getJobROIAssocJSON() {
		return jobROIAssocJSON;
	}

	public void setJobROIAssocJSON(String jobROIAssocJSON) {
		this.jobROIAssocJSON = jobROIAssocJSON;
	}

	public List<CBFROIJobAssociation> getFinalRoiJobAssocList() {
		return finalRoiJobAssocList;
	}

	public void setFinalRoiJobAssocList(
			List<CBFROIJobAssociation> finalRoiJobAssocList) {
		this.finalRoiJobAssocList = finalRoiJobAssocList;
	}

	public String getUserJobRoiAssocJSON() {
		return userJobRoiAssocJSON;
	}

	public void setUserJobRoiAssocJSON(String userJobRoiAssocJSON) {
		this.userJobRoiAssocJSON = userJobRoiAssocJSON;
	}

	public String getSubmittedJobId() {
		return submittedJobId;
	}

	public void setSubmittedJobId(String submittedJobId) {
		this.submittedJobId = submittedJobId;
	}

	public String[] getSelectedJobsItems() {
		return selectedJobsItems;
	}

	public void setSelectedJobsItems(String[] selectedJobsItems) {
		this.selectedJobsItems = selectedJobsItems;
	}

	public FactorSelectionInfo getFactorSelectionInfo() {
		return factorSelectionInfo;
	}

	public void setFactorSelectionInfo(FactorSelectionInfo factorSelectionInfo) {
		this.factorSelectionInfo = factorSelectionInfo;
	}

	public List<FactorRepeatedMeasureInfo> getFrmiList() {
		return frmiList;
	}

	public void setFrmiList(List<FactorRepeatedMeasureInfo> frmiList) {
		this.frmiList = frmiList;
	}

	public String getJobType() {
		return jobType;
	}

	public void setJobType(String jobType) {
		this.jobType = jobType;
	}

	public WizardPageState getCurPage() {
		return curPage;
	}

	public void setCurPage(WizardPageState curPage) {
		this.curPage = curPage;
	}

	public static class FactorSelectionInfo {
		private final List<FactorRepeatedMeasureInfo> selectedFactors;
		private final boolean repeatedMeasure;

		public FactorSelectionInfo(
				final List<FactorRepeatedMeasureInfo> selectedFactors,
				boolean repeatedMeasure) {
			this.selectedFactors = selectedFactors;
			this.repeatedMeasure = repeatedMeasure;
		}

		public List<FactorRepeatedMeasureInfo> getSelectedFactors() {
			return selectedFactors;
		}

		public boolean isRepeatedMeasure() {
			return repeatedMeasure;
		}

	}// ;

	public String getSelectedJobItemsJSON() {
		if (selectedJobsItems != null) {
			JSONArray jsArr = new JSONArray();
			for (String selJobItem : selectedJobsItems) {
				jsArr.put(selJobItem);
			}
			return jsArr.toString();
		} else {
			return "[]";
		}
	}

	public String getGaName() {
		return gaName;
	}

	public void setGaName(String gaName) {
		this.gaName = gaName;
	}

	public boolean isDoQWarp() {
		return doQWarp;
	}

	public void setDoQWarp(boolean doQWarp) {
		this.doQWarp = doQWarp;
	}
}
