package clinical.web.forms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import clinical.web.common.security.User;
import clinical.web.common.security.User.PrivilegeExperiments;
import clinical.web.common.security.User.ProjectPrivilegeStatus;
import clinical.web.vo.ExperimentInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UserProjectPrivMatrix.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class UserProjectPrivMatrix {
	User webUser;
	List<ExperimentInfo> experiments;
	Map<String, List<ProjectPrivilegeStatus>> privStatusListMap = new HashMap<String, List<ProjectPrivilegeStatus>>(
			17);

	public UserProjectPrivMatrix(User webUser, int maxSize) {
		this.webUser = webUser;
		experiments = new ArrayList<ExperimentInfo>(maxSize);
		for (PrivilegeExperiments pe : webUser.getPrivExperiments()) {
			List<ProjectPrivilegeStatus> ppStatusList = new ArrayList<ProjectPrivilegeStatus>(
					maxSize);
			privStatusListMap.put(pe.getPrivilege(), ppStatusList);
		}
	}

	void add(ExperimentInfo ei,
			Map<String, ProjectPrivilegeStatus> ppStatusMap) {
		experiments.add(ei);
		for (String privName : ppStatusMap.keySet()) {
			List<ProjectPrivilegeStatus> ppStatusList = privStatusListMap
					.get(privName);
			ppStatusList.add(ppStatusMap.get(privName));
		}
	}

	public User getWebUser() {
		return webUser;
	}

	public List<ExperimentInfo> getExperiments() {
		return experiments;
	}

	public Map<String, List<ProjectPrivilegeStatus>> getPrivStatusListMap() {
		return privStatusListMap;
	}

}