package clinical.web.game;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 
 * Holds information about a Struts Form bean, its associated assessment name
 * and form variables per page as keyed <code>PageVariableInfo</code> objects.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: FormBeanInfo.java 366 2011-05-05 20:06:27Z bozyurt $
 * 
 */
public class FormBeanInfo {
	private String assessmentName;
	private String formBeanClass;
	private Map<Integer, Map<String, PageVariableInfo>> varsPerPageMap = 
		new LinkedHashMap<Integer, Map<String, PageVariableInfo>>(11);
	private Map<Integer, Map<Integer, PageQuestionInfo>> questionsPerPageMap = 
		new LinkedHashMap<Integer, Map<Integer, PageQuestionInfo>>(11);
	private Map<String, MandatoryFieldMetaData> mandatoryFieldMetaDataMap = 
		new LinkedHashMap<String, MandatoryFieldMetaData>(3);

	public FormBeanInfo(String assessmentName, String formBeanClass) {
		this.assessmentName = assessmentName;
		this.formBeanClass = formBeanClass;
	}

	public String getAssessmentName() {
		return this.assessmentName;
	}

	public String getFormBeanClass() {
		return this.formBeanClass;
	}

	public void addPageVariableInfo(PageVariableInfo pvi) {
		Integer pageNum = new Integer(pvi.getPageNumber());
		Map<String, PageVariableInfo> pageVarInfoMap = varsPerPageMap
				.get(pageNum);
		if (pageVarInfoMap == null) {
			pageVarInfoMap = new HashMap<String, PageVariableInfo>(11);
			varsPerPageMap.put(pageNum, pageVarInfoMap);
		}
		pageVarInfoMap.put(pvi.getDbVarName(), pvi);
	}

	public void addPageQuestionInfo(PageQuestionInfo pqi) {
		Integer pageNum = new Integer(pqi.getPageNumber());
		Map<Integer, PageQuestionInfo> pageQuestInfoMap = questionsPerPageMap
				.get(pageNum);
		if (pageQuestInfoMap == null) {
			pageQuestInfoMap = new HashMap<Integer, PageQuestionInfo>(11);
			questionsPerPageMap.put(pageNum, pageQuestInfoMap);
		}
		pageQuestInfoMap.put(new Integer(pqi.getQuestionNumber()), pqi);
	}

	public PageQuestionInfo getPageQuestionInfo(Integer questionID) {
		for(Map <Integer,PageQuestionInfo> pageQuestInfoMap : questionsPerPageMap.values()) {
			
			PageQuestionInfo pqi = (PageQuestionInfo) pageQuestInfoMap
					.get(questionID);
			if (pqi != null) {
				return pqi;
			}
		}
		return null;
	}

	public void addMandatoryFieldMetaData(MandatoryFieldMetaData mfmd) {
		mandatoryFieldMetaDataMap.put(mfmd.getFieldName(), mfmd);
	}

	public Map<Integer,PageQuestionInfo> getPageQuestions(int pageNumber) {
		return questionsPerPageMap.get(new Integer(pageNumber));
	}

	public Map<Integer, Map<String, PageVariableInfo>> getVarsPerPageMap() {
		return varsPerPageMap;
	}

	public Map<String,PageVariableInfo> getPageVars(int pageNumber) {
		return varsPerPageMap.get(new Integer(pageNumber));
	}

	public Map<String,PageVariableInfo> getPageVars(Integer pageNumber) {
		return varsPerPageMap.get(pageNumber);
	}

	public int getVarsPerPageMapSize() {
		return varsPerPageMap.size();
	}

	public MandatoryFieldMetaData getMandatoryFieldMetaData(String fieldName) {
		return mandatoryFieldMetaDataMap.get(fieldName);
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("FormBeanInfo ::[");
		buf.append("assessmentName=").append(assessmentName).append(
				",formBeanClass=");
		buf.append(formBeanClass);
		
		for (Map<String, PageVariableInfo> map : varsPerPageMap.values()) {
			for (PageVariableInfo pvi : map.values()) {
				buf.append('\n').append(pvi.toString());
			}
		}
		buf.append(']');
		return buf.toString();
	}
}