package clinical.web.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.utils.Assertion;
import clinical.utils.DateTimeUtils;
import clinical.web.common.vo.CBFProcessReportRec;
import clinical.web.vo.CBFROIJobAssociation;
import clinical.web.vo.CBFROIJobAssociation.JobVisitInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class CBFROIGroupAnalysisHelper {

	public static JSONArray toROIList(List<CBFROIJobAssociation> assocList)
			throws JSONException {
		JSONArray jsArr = new JSONArray();
		for (CBFROIJobAssociation assoc : assocList) {
			jsArr.put(toROI(assoc));
		}
		return jsArr;
	}

	public static JSONArray toJobList(List<CBFProcessReportRec> cbfRecList)
			throws JSONException {
		JSONArray jsArr = new JSONArray();
		Map<String, List<CBFProcessReportRec>> map = new HashMap<String, List<CBFProcessReportRec>>();
		for (CBFProcessReportRec cbfRef : cbfRecList) {
			String subjectID = cbfRef.getSubjectID();
			String expName = cbfRef.getProjectName();
			String key = subjectID + ":" + expName;
			List<CBFProcessReportRec> list = map.get(key);
			if (list == null) {
				list = new ArrayList<CBFProcessReportRec>(5);
				map.put(key, list);
			}
			list.add(cbfRef);
		}
		for (String key : map.keySet()) {
			String[] toks = key.split(":");
			String subjectID = toks[0];
			String expName = toks[1];
			JSONObject js = new JSONObject();
			js.put("subject", subjectID);
			js.put("expName", expName);
			jsArr.put(js);
			JSONArray jobArr = new JSONArray();
			js.put("jobs", jobArr);
			List<CBFProcessReportRec> list = map.get(key);
			for (CBFProcessReportRec cbfRec : list) {
				jobArr.put(toJob(cbfRec));
			}
		}
		return jsArr;
	}

	public static JSONObject toJob(CBFProcessReportRec cbfRec)
			throws JSONException {
		JSONObject js = new JSONObject();
		js.put("jid", cbfRec.getJobID());
		js.put("vid", cbfRec.getVisitId());
		js.put("vd", DateTimeUtils.formatDate(cbfRec.getVisitDate()));
		js.put("label", cbfRec.getTag());
		if (cbfRec.getVisitName() != null) {
			js.put("desc", cbfRec.getVisitName());
		}

		return js;
	}

	public static JSONObject toROI(CBFROIJobAssociation assoc)
			throws JSONException {
		JSONObject js = new JSONObject();
		js.put("brik", assoc.getRelativeBrikPath());
		js.put("subject", assoc.getSubjectId());
		if (assoc.getVisitDate() != null) {
			js.put("vd", assoc.getVisitDate());
		}
		return js;
	}

	public static List<CBFROIJobAssociation> prepFromAssociationResults(
			String assocResultJSONStr, List<CBFROIJobAssociation> assocList)
			throws JSONException {
		JSONObject resultsObj = new JSONObject(assocResultJSONStr);
		JSONArray jsArr = resultsObj.getJSONArray("results");
		List<CBFROIJobAssociation> resultAssocList = new ArrayList<CBFROIJobAssociation>(
				assocList.size());
		Map<String, CBFROIJobAssociation> map = new HashMap<String, CBFROIJobAssociation>();
		for (CBFROIJobAssociation assoc : assocList) {
			String key = assoc.getRelativeBrikPath();
			Assertion.assertFalse(map.containsKey(key));
			map.put(key, assoc);
		}
		for (int i = 0; i < jsArr.length(); i++) {
			JSONObject jsObj = jsArr.getJSONObject(i);
			JSONObject roiJS = jsObj.getJSONObject("roi");
			String key = roiJS.getString("brik");
			String subjectID = roiJS.getString("subject");
			String visitDate = roiJS.getString("vd");
			CBFROIJobAssociation assoc = map.get(key);
			CBFROIJobAssociation finalAssoc = new CBFROIJobAssociation(
					assoc.getRoiMaskBrik(), subjectID, visitDate,
					assoc.getRootDir());
			resultAssocList.add(finalAssoc);
			JSONArray jsJobsArr = jsObj.getJSONArray("jobs");
			// String expName = jsObj.getString("expName");
			for(int j = 0; j < jsJobsArr.length(); j++) {
				JSONObject jobJS = jsJobsArr.getJSONObject(j);
				String jobID = jobJS.getString("jid");
				int visitID = jobJS.getInt("vid");
				for(JobVisitInfo jvi : assoc.getCandidates()) {
					if (jvi.getJobID().equals(jobID) && jvi.getVisitID() == visitID) {
						finalAssoc.addCandidate(jvi);
						break;
					}
				}
			}
		}
		return resultAssocList;
	}
	
}
