package clinical.web.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

import org.apache.struts.util.LabelValueBean;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CountrySelector.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class CountrySelector implements Serializable {
	private static final long serialVersionUID = 1L;
	protected Collection<LabelValueBean> countries;
	protected String selectedCountry;
	private static final String[] countryArr= { "Afghanistan", "Albania", "Algeria",
		"American Samoa", "Andorra", "Angola", "Anguilla", "Antarctica",
		"Antigua and Barbuda", "Argentina", "Armenia", "Aruba",
		"Australia", "Austria", "Azerbaijan", "Bahamas", "Bahrain",
		"Bangladesh", "Barbados", "Belarus", "Belgium", "Belize", "Benin",
		"Bermuda", "Bhutan", "Bolivia", "Bosnia and Herzegovina",
		"Botswana", "Bouvet Island", "Brazil",
		"British Indian Ocean Territory", "Brunei", "Bulgaria",
		"Burkina Faso", "Burundi", "Cambodia", "Cameroon", "Canada",
		"Cape Verde", "Cayman Islands", "Central African Republic", "Chad",
		"Chile", "China", "Christmas Island", "Cocos (Keeling) Islands",
		"Colombia", "Comoros", "Congo",
		"Congo, The Democratic Republic of the", "Cook Islands",
		"Costa Rica", "Côte d’Ivoire", "Croatia", "Cuba", "Cyprus",
		"Czech Republic", "Denmark", "Djibouti", "Dominica",
		"Dominican Republic", "East Timor", "Ecuador", "Egypt",
		"El Salvador", "Equatorial Guinea", "Eritrea", "Estonia",
		"Ethiopia", "Falkland Islands", "Faroe Islands", "Fiji Islands",
		"Finland", "France", "French Guiana", "French Polynesia",
		"French Southern territories", "Gabon", "Gambia", "Georgia",
		"Germany", "Ghana", "Gibraltar", "Greece", "Greenland", "Grenada",
		"Guadeloupe", "Guam", "Guatemala", "Guinea", "Guinea-Bissau",
		"Guyana", "Haiti", "Heard Island and McDonald Islands",
		"Holy See (Vatican City State)", "Honduras", "Hong Kong",
		"Hungary", "Iceland", "India", "Indonesia", "Iran", "Iraq",
		"Ireland", "Israel", "Italy", "Jamaica", "Japan", "Jordan",
		"Kazakstan", "Kenya", "Kiribati", "Kuwait", "Kyrgyzstan", "Laos",
		"Latvia", "Lebanon", "Lesotho", "Liberia",
		"Libyan Arab Jamahiriya", "Liechtenstein", "Lithuania",
		"Luxembourg", "Macao", "Macedonia", "Madagascar", "Malawi",
		"Malaysia", "Maldives", "Mali", "Malta", "Marshall Islands",
		"Martinique", "Mauritania", "Mauritius", "Mayotte", "Mexico",
		"Micronesia, Federated States of", "Moldova", "Monaco", "Mongolia",
		"Montserrat", "Morocco", "Mozambique", "Myanmar", "Namibia",
		"Nauru", "Nepal", "Netherlands", "Netherlands Antilles",
		"New Caledonia", "New Zealand", "Nicaragua", "Niger", "Nigeria",
		"Niue", "Norfolk Island", "North Korea",
		"Northern Mariana Islands", "Norway", "Oman", "Pakistan", "Palau",
		"Palestine", "Panama", "Papua New Guinea", "Paraguay", "Peru",
		"Philippines", "Pitcairn", "Poland", "Portugal", "Puerto Rico",
		"Qatar", "Réunion", "Romania", "Russian Federation", "Rwanda",
		"Saint Helena", "Saint Kitts and Nevis", "Saint Lucia",
		"Saint Pierre and Miquelon", "Saint Vincent and the Grenadines",
		"Samoa", "San Marino", "Sao Tome and Principe", "Saudi Arabia",
		"Senegal", "Seychelles", "Sierra Leone", "Singapore", "Slovakia",
		"Slovenia", "Solomon Islands", "Somalia", "South Africa",
		"South Georgia and the South Sandwich Islands", "South Korea",
		"Spain", "Sri Lanka", "Sudan", "Suriname",
		"Svalbard and Jan Mayen", "Swaziland", "Sweden", "Switzerland",
		"Syria", "Taiwan", "Tajikistan", "Tanzania", "Thailand", "Togo",
		"Tokelau", "Tonga", "Trinidad and Tobago", "Tunisia", "Turkey",
		"Turkmenistan", "Turks and Caicos Islands", "Tuvalu", "Uganda",
		"Ukraine", "United Arab Emirates", "United Kingdom",
		"United States", "United States Minor Outlying Islands", "Uruguay",
		"Uzbekistan", "Vanuatu", "Venezuela", "Vietnam",
		"Virgin Islands, British", "Virgin Islands, U.S.",
		"Wallis and Futuna", "Western Sahara", "Yemen", "Yugoslavia",
		"Zambia", "Zimbabwe" };
	
	public CountrySelector() {
		countries = new ArrayList<LabelValueBean>(countryArr.length);
		for(String country : countryArr) {
			LabelValueBean lvb = new LabelValueBean(country, country);
			countries.add(lvb);
			if (country.equals("United States")) {
				this.selectedCountry = country;
			}
		}
	}

	public String getSelectedCountry() {
		return selectedCountry;
	}

	public void setSelectedCountry(String selectedCountry) {
		this.selectedCountry = selectedCountry;
	}

	public Collection<LabelValueBean> getCountries() {
		return countries;
	}
	
}
