package clinical.web.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Experiment;

public class MultipleExperimentSelector implements Serializable {
	private static final long serialVersionUID = 1L;
	protected Collection<LabelValueBean> experimentInfos;
	protected int[] selectedExpIDs;
	public final static int ALL_EXPERIMENTS = -1;
	
	public MultipleExperimentSelector(List<Experiment> experiments) {
		experimentInfos = new ArrayList<LabelValueBean>(experiments.size() + 1);
		LabelValueBean lvb = new LabelValueBean("All Experiments", String
				.valueOf(ALL_EXPERIMENTS));
		experimentInfos.add(lvb);
		for (Experiment exp : experiments) {
			lvb = new LabelValueBean(exp.getName(), exp.getUniqueid()
					.toString());
			experimentInfos.add(lvb);
		}
		selectedExpIDs = new int[ 1];
		selectedExpIDs[0] = ALL_EXPERIMENTS;
	}

	public int[] getSelectedExpIDs() {
		return selectedExpIDs;
	}

	public void setSelectedExpIDs(int[] selectedExpIDs) {
		this.selectedExpIDs = selectedExpIDs;
	}

	public Collection<LabelValueBean> getExperimentInfos() {
		return experimentInfos;
	}
	
	public void reset() {
		selectedExpIDs = new int[ 1];
		selectedExpIDs[0] = ALL_EXPERIMENTS;
	}
}
