package clinical.web.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

import org.apache.struts.util.LabelValueBean;

public class RefIdTypeSelector implements Serializable {
	private static final long serialVersionUID = 1L;
	protected Collection<LabelValueBean> refIdTypes;
	private String selectedRefIdType;
	public final static String PMID = "PMID";
	public final static String DOI = "DOI";

	public RefIdTypeSelector() {
		refIdTypes = new ArrayList<LabelValueBean>(2);
		LabelValueBean lvb = new LabelValueBean(PMID, PMID);
		refIdTypes.add(lvb);
		lvb = new LabelValueBean(DOI, DOI);
		refIdTypes.add(lvb);
		this.setSelectedRefIdType(PMID);
	}

	public void setSelectedRefIdType(String selectedRefIdType) {
		this.selectedRefIdType = selectedRefIdType;
	}

	public String getSelectedRefIdType() {
		return selectedRefIdType;
	}

	public Collection<LabelValueBean> getRefIdTypes() {
		return refIdTypes;
	}

}
