package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ScoreValueSummaryHeader.java,v 1.3 2006/04/06 00:01:08 bozyurt
 *          Exp $
 */

public class ScoreValueSummaryHeader implements java.io.Serializable {
	private static final long serialVersionUID = 4576863496147073019L;
	private List<HeaderInfo> headers = new ArrayList<HeaderInfo>(3);
	public final static int MAX_ITEM_PER_LINE = 10;

	public ScoreValueSummaryHeader() {
	}

	public void addHeader(HeaderInfo hi) {
		headers.add(hi);
	}

	public HeaderInfo getHeader(int idx) {
		return headers.get(idx);
	}

	public List<HeaderInfo> getHeaders() {
		return headers;
	}

	/**
	 * 
	 * @return a list of header lines where each line contains enough
	 *         <code>HeaderInfo</code> objects per line
	 */
	public List<List<HeaderInfo>> getHeaderLines() {
		int count = countHeaderItems(headers);
		List<List<HeaderInfo>> headerLines = new ArrayList<List<HeaderInfo>>(1);
		if (count > MAX_ITEM_PER_LINE) {
			int startIdx = 0;
			do {
				List<HeaderInfo> headerLine = getHeadersForLine(startIdx);
				headerLines.add(headerLine);
				startIdx += countHeaderItems(headerLine);
				if (startIdx >= count)
					break;

			} while (true);
		}
		return headerLines;
	}

	protected List<HeaderInfo> getHeadersForLine(int startIdx) {
		List<HeaderInfo> headerLine = new ArrayList<HeaderInfo>(5);
		ListIterator<HeaderInfo> iter = headers.listIterator(startIdx);
		int count = 0;
		while (iter.hasNext()) {
			HeaderInfo hi = iter.next();
			if (count + hi.getSize() <= MAX_ITEM_PER_LINE) {
				headerLine.add(hi);
			} else {
				break;
			}
			count += hi.getSize();
		}
		return headerLine;
	}

	public static int countHeaderItems(List<HeaderInfo> headerList) {
		int count = 0;
		for (Iterator<HeaderInfo> iter = headerList.iterator(); iter.hasNext();) {
			HeaderInfo hi = iter.next();
			count += hi.getSize();
		}
		return count;
	}

}
