package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Site;

/**
 * @author I. Burak Ozyurt
 * @version $Id: SiteSelector.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class SiteSelector {
	protected Collection<LabelValueBean> siteList;
	protected String selectedSiteUniqueId;
	
	public SiteSelector(List<Site> sites) {
		siteList = new ArrayList<LabelValueBean>(sites.size());
		for (Site site : sites) {
			siteList.add( new LabelValueBean(site.getSitename(), site.getUniqueid().toString()));
			if ( selectedSiteUniqueId == null) {
				selectedSiteUniqueId = site.getUniqueid().toString();
			}
		}
	}

	public Collection<LabelValueBean> getSiteList() {
		return siteList;
	}

	public String getSelectedSiteUniqueId() {
		return selectedSiteUniqueId;
	}

	public void setSelectedSiteUniqueId(String selectedSiteUniqueId) {
		this.selectedSiteUniqueId = selectedSiteUniqueId;
	}
}
