package clinical.web.helpers;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StatsResultsData.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class StatsResultsData {
	protected String varName;
	protected String imagePath;
	protected String qqImagePath;

	protected String text;

	public StatsResultsData() {
	}

	public StatsResultsData(String varName, String imagePath, String text,
			String qqImagePath) {
		this.varName = varName;
		this.imagePath = imagePath;
		this.text = text;
		this.qqImagePath = qqImagePath;
	}

	// ---------------------- setters --------------

	public void setVarName(String newVarName)
	{
		this.varName = newVarName;
	}

	public void setImagePath(String newImagePath)
	{
		this.imagePath = newImagePath;
	}

	public void setText(String newText)
	{
		this.text = newText;
	}

	// ---------------------- getters --------------
	public String getVarName()
	{
		return this.varName;
	}

	public String getImagePath()
	{
		return this.imagePath;
	}

	public String getText()
	{
		return this.text;
	}

	public boolean equals(Object other)
	{
		if (other == null) {
			return false;
		}
		if (other == this) {
			return true;
		}
		if (!(other instanceof StatsResultsData)) {
			return false;
		}
		StatsResultsData that = (StatsResultsData) other;
		if ((varName != null && that.varName != null && varName
				.equals(that.varName))
				&& (imagePath != null && that.imagePath != null && imagePath
						.equals(that.imagePath))
				&& (text != null && that.text != null && text.equals(that.text))) {
			return true;
		}
		return false;
	}

	public int hashCode()
	{
		int result = 14;
		result = 29 * result + varName.hashCode();
		result = 29 * result + imagePath.hashCode();
		result = 29 * result + text.hashCode();
		return result;
	}

	public String toString()
	{
		StringBuffer buf = new StringBuffer(104);
		buf.append("StatsResultsData::[");
		buf.append("varName=").append(varName);
		buf.append(", imagePath=").append(imagePath);
		buf.append(", text=").append(text);
		buf.append(']');
		return buf.toString();
	}

	public String getQqImagePath()
	{
		return qqImagePath;
	}

	public void setQqImagePath(String qqImagePath)
	{
		this.qqImagePath = qqImagePath;
	}

}
