package clinical.web.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.web.common.security.User;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id$
 */
public class WebUserSelector implements Serializable {
	private static final long serialVersionUID = 1L;
	protected Collection<LabelValueBean> userList;
	protected String selectedUser;

	public WebUserSelector(List<User> webUsers) {
		userList = new ArrayList<LabelValueBean>(webUsers.size());
		for (User wu : webUsers) {
			userList.add(new LabelValueBean(wu.getName(), wu.getName()));
			if (selectedUser == null) {
				selectedUser = wu.getName();
			}
		}
	}

	public String getSelectedUser() {
		return selectedUser;
	}

	public void setSelectedUser(String selectedUser) {
		this.selectedUser = selectedUser;
	}

	public Collection<LabelValueBean> getUserList() {
		return userList;
	}
}
