package clinical.web.image.viewer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import clinical.utils.PluginManUtils;
import clinical.web.download.FileInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: PluginManager.java 366 2011-05-05 20:06:27Z bozyurt $
 */
public class PluginManager {
	protected static PluginManager instance;
	protected Map<String, IPlugin> pluginMap = new HashMap<String, IPlugin>(7);

	protected PluginManager() {
		detectAndCachePlugins("clinical.web.image.viewer.plugins");
	}

	public static synchronized PluginManager getInstance() {
		if (instance == null) {
			instance = new PluginManager();
		}
		return instance;
	}

	public IPlugin getPlugin(String imageType) {
		return pluginMap.get(imageType.toUpperCase());
	}
	
	public List<String> getRegisteredImageTypes() {
		return new ArrayList<String>( pluginMap.keySet() );
	}

	public IPlugin getPlugin(int imageType) {
		switch (imageType) {
		case FileInfo.ANALYZE_7_5:
			return pluginMap.get("ANALYZE_7_5");
		case FileInfo.DICOM:
			return pluginMap.get("DICOM");
		case FileInfo.NIFTI:
			return pluginMap.get("NIFTI");
		case FileInfo.GZIPPED_NIFTI:
			return pluginMap.get("GZIPPED_NIFTI");
		default:
			return null;
		}
	}

	protected void detectAndCachePlugins(String pluginsPackageName) {
		List<Object> plugins = PluginManUtils.detectPlugins(pluginsPackageName,
				IPlugin.class, null);
		for (Object o : plugins) {
			IPlugin plugin = (IPlugin) o;
			String[] supportedImageTypes = plugin.getSupportedImageTypes();
			if (supportedImageTypes != null) {
				for (int j = 0; j < supportedImageTypes.length; j++) {
					pluginMap.put(supportedImageTypes[j].toUpperCase(), plugin);
				}
			}
		}
	}


}
